/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate.rest.resources;

import com.atlassian.plugin.PluginException;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.upm.selfupdate.UpdateController;
import com.atlassian.upm.selfupdate.UpdateParameters;
import com.atlassian.upm.selfupdate.UpdateParametersFactory;
import com.atlassian.upm.selfupdate.async.SimpleAsyncTaskManager;
import com.atlassian.upm.selfupdate.async.TaskStatus;
import com.atlassian.upm.selfupdate.rest.representations.TaskRepresentation;
import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSudoRequired
@Path(value="/")
public class ExecuteUpdateResource {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteUpdateResource.class);
    private static final String INSTALL_TYPE = "PLUGIN_INSTALL";
    private static final int DEFAULT_POLL_DELAY_MS = 100;
    private final SimpleAsyncTaskManager simpleAsyncTaskManager;
    private final UpdateController updateController;
    private final UpdateParametersFactory configuration;

    public ExecuteUpdateResource(SimpleAsyncTaskManager simpleAsyncTaskManager, UpdateController updateController, UpdateParametersFactory configuration) {
        this.simpleAsyncTaskManager = (SimpleAsyncTaskManager)Preconditions.checkNotNull((Object)simpleAsyncTaskManager, (Object)"simpleAsyncTaskManager");
        this.updateController = (UpdateController)Preconditions.checkNotNull((Object)updateController, (Object)"updateController");
        this.configuration = (UpdateParametersFactory)Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/vnd.atl.plugins.pending-task+json"})
    public Response execute() {
        final UpdateParameters params = this.configuration.getUpdateParameters();
        if (params == null) {
            logger.warn("Update resource was called without being preconfigured; ignoring request");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.configuration.reset();
        final String source = params.getJarToInstall().getName();
        this.configuration.reset();
        Callable<TaskStatus> installHandler = new Callable<TaskStatus>(){

            @Override
            public TaskStatus call() throws Exception {
                try {
                    ExecuteUpdateResource.this.updateController.performUpdate(params);
                }
                catch (PluginException e) {
                    logger.warn(e.getMessage());
                    return TaskStatus.error(e.getMessage(), source);
                }
                return TaskStatus.success(params.getSelfUpdatePluginUri(), source);
            }
        };
        TaskRepresentation taskRep = this.simpleAsyncTaskManager.start(installHandler, INSTALL_TYPE, source, 100).getRepresentation();
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)taskRep).type("application/vnd.atl.plugins.pending-task+json").location(taskRep.getSelf()).build();
    }
}

