/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate.rest.resources;

import com.atlassian.plugin.PluginException;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.upm.selfupdate.UpdateController;
import com.atlassian.upm.selfupdate.UpdateParameters;
import com.atlassian.upm.selfupdate.UpdateParametersFactory;
import com.atlassian.upm.selfupdate.rest.representations.InternalUpdateParams;
import com.google.common.base.Preconditions;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="/immediate")
public class ExecuteUpdateInternallyResource {
    private static final Logger logger = LoggerFactory.getLogger(ExecuteUpdateInternallyResource.class);
    private final UpdateController updateController;
    private final UpdateParametersFactory configuration;

    public ExecuteUpdateInternallyResource(UpdateController updateController, UpdateParametersFactory configuration) {
        this.updateController = (UpdateController)Preconditions.checkNotNull((Object)updateController, (Object)"updateController");
        this.configuration = (UpdateParametersFactory)Preconditions.checkNotNull((Object)configuration, (Object)"configuration");
    }

    @POST
    @Consumes(value={"application/vnd.atl.plugins.install.self-update+json"})
    public Response execute(InternalUpdateParams requestParams) {
        UpdateParameters params = this.configuration.getUpdateParameters();
        if (params == null) {
            logger.warn("Update resource was called without being preconfigured; ignoring request");
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        if (!params.getJarToInstall().getPath().equals(requestParams.getUpmJarPath())) {
            logger.warn("Internal update resource was called with invalid parameters; ignoring request");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.configuration.reset();
        try {
            this.updateController.performUpdate(params);
        }
        catch (PluginException e) {
            logger.warn("Internal update request failed: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().build();
    }
}

