/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate.rest.representations;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.annotate.JsonProperty;

public class TaskStatusRepresentation {
    private final int statusCode;
    private final String contentType;
    @JsonProperty
    private final String source;

    protected TaskStatusRepresentation(int statusCode, String contentType, String source) {
        this.statusCode = statusCode;
        this.contentType = contentType;
        this.source = source;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSource() {
        return this.source;
    }

    public static TaskStatusRepresentation inProgress(String source) {
        return new InProgressRepresentation(source);
    }

    public static TaskStatusRepresentation success(URI installedPluginUri, String source) {
        return new SuccessRepresentation(installedPluginUri, source);
    }

    public static TaskStatusRepresentation error(String message, String source) {
        return new ErrorRepresentation(message, source);
    }

    static class ErrorRepresentation
    extends TaskStatusRepresentation {
        @JsonProperty
        String subCode;

        ErrorRepresentation(String subCode, String source) {
            super(Response.Status.OK.getStatusCode(), "application/vnd.atl.plugins.task.install.err+json", source);
            this.subCode = subCode;
        }

        public String getSubCode() {
            return this.subCode;
        }
    }

    static class SuccessRepresentation
    extends TaskStatusRepresentation {
        @JsonProperty
        URI cleanupDeleteUri;
        @JsonProperty
        Boolean requiresRefresh;

        SuccessRepresentation(URI cleanupDeleteUri, String source) {
            super(Response.Status.ACCEPTED.getStatusCode(), "application/vnd.atl.plugins.install.next-task+json", source);
            this.cleanupDeleteUri = cleanupDeleteUri;
            this.requiresRefresh = true;
        }

        public URI getCleanupDeleteUri() {
            return this.cleanupDeleteUri;
        }

        public Boolean getRequiresRefresh() {
            return this.requiresRefresh;
        }
    }

    static class InProgressRepresentation
    extends TaskStatusRepresentation {
        InProgressRepresentation(String source) {
            super(Response.Status.OK.getStatusCode(), "application/vnd.atl.plugins.install.installing+json", source);
        }
    }
}

