/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate.async;

import com.atlassian.sal.usercompatibility.UserKey;
import com.atlassian.upm.selfupdate.async.TaskStatus;
import com.atlassian.upm.selfupdate.rest.representations.TaskRepresentation;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;

public class SimpleAsynchronousTask
implements Runnable {
    private final Callable<TaskStatus> handler;
    private final int pollDelay;
    private final Date timestamp;
    private final String type;
    private final URI uri;
    private final UserKey userKey;
    private final String source;
    private final AtomicReference<TaskStatus> statusHolder;

    public SimpleAsynchronousTask(Callable<TaskStatus> handler, String type, String source, int pollDelay, URI uri, UserKey userKey) {
        this.handler = handler;
        this.statusHolder = new AtomicReference<TaskStatus>(TaskStatus.inProgress(source));
        this.source = source;
        this.pollDelay = pollDelay;
        this.timestamp = new Date();
        this.type = type;
        this.uri = uri;
        this.userKey = userKey;
    }

    @Override
    public void run() {
        try {
            TaskStatus result = this.handler.call();
            this.statusHolder.set(result);
        }
        catch (Exception e) {
            this.statusHolder.set(TaskStatus.error(e.toString(), this.source));
        }
    }

    public TaskRepresentation getRepresentation() {
        TaskStatus status = this.statusHolder.get();
        return new TaskRepresentation(this.type, status.isDone() ? null : Integer.valueOf(this.pollDelay), status.getRepresentation(), (Map<String, URI>)ImmutableMap.of((Object)"self", (Object)this.uri), this.timestamp, this.userKey.getStringValue());
    }
}

