/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate.async;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.sal.usercompatibility.UserKey;
import com.atlassian.sal.usercompatibility.UserManager;
import com.atlassian.upm.selfupdate.async.SimpleAsynchronousTask;
import com.atlassian.upm.selfupdate.async.TaskStatus;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.DisposableBean;

public class SimpleAsyncTaskManager
implements DisposableBean {
    private final ApplicationProperties applicationProperties;
    private final ExecutorService executor;
    private final AtomicReference<SimpleAsynchronousTask> currentTask;
    private final UserManager userManager;

    public SimpleAsyncTaskManager(ApplicationProperties applicationProperties, ThreadLocalDelegateExecutorFactory executorFactory, UserManager userManager) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        ExecutorService delegateExecutor = Executors.newFixedThreadPool(1);
        this.executor = ((ThreadLocalDelegateExecutorFactory)Preconditions.checkNotNull((Object)executorFactory, (Object)"executorFactory")).createExecutorService(delegateExecutor);
        this.currentTask = new AtomicReference();
    }

    public SimpleAsynchronousTask getTask() {
        return this.currentTask.get();
    }

    public SimpleAsynchronousTask start(Callable<TaskStatus> handler, String type, String source, int pollDelay) {
        UserKey userKey;
        URI taskUri = URI.create(this.applicationProperties.getBaseUrl() + "/rest/plugins/self-update/1.0" + "/tasks/default");
        SimpleAsynchronousTask task = new SimpleAsynchronousTask(handler, type, source, pollDelay, taskUri, userKey = this.userManager.getRemoteUserKey());
        if (!this.currentTask.compareAndSet(null, task)) {
            throw new IllegalStateException("Cannot start a task because one has already been started");
        }
        this.executor.execute(task);
        return task;
    }

    public void destroy() {
        this.executor.shutdown();
    }
}

