/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.selfupdate.UpdateParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.util.Collection;

public class UpdateParametersFactory {
    private PluginSettingsFactory pluginSettingsFactory;

    public UpdateParametersFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = (PluginSettingsFactory)Preconditions.checkNotNull((Object)pluginSettingsFactory, (Object)"pluginSettingsFactory");
    }

    public UpdateParameters getUpdateParameters() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        Object jarPathValue = settings.get("com.atlassian.upm:selfupdate.jar");
        Object upmKeyValue = settings.get("com.atlassian.upm:selfupdate.key");
        Object upmUriValue = settings.get("com.atlassian.upm:selfupdate.upm.uri");
        Object selfUpdatePluginUriValue = settings.get("com.atlassian.upm:selfupdate.stub.uri");
        Object enabledPluginKeys = settings.get("com.atlassian.upm:selfupdate.plugins.enabled");
        Object upmCompletionUriValue = settings.get("com.atlassian.upm:selfupdate.upm.post.uri");
        if (jarPathValue == null || upmKeyValue == null || upmUriValue == null || selfUpdatePluginUriValue == null || enabledPluginKeys == null) {
            return null;
        }
        return new UpdateParameters(new File(jarPathValue.toString()), upmKeyValue.toString(), URI.create(upmUriValue.toString()), URI.create(selfUpdatePluginUriValue.toString()), (Iterable<String>)ImmutableList.copyOf((Collection)Lists.newArrayList((Object[])enabledPluginKeys.toString().split(","))), upmCompletionUriValue == null ? null : URI.create(upmCompletionUriValue.toString()));
    }

    public void reset() {
        PluginSettings settings = this.pluginSettingsFactory.createGlobalSettings();
        settings.remove("com.atlassian.upm:selfupdate.jar");
        settings.remove("com.atlassian.upm:selfupdate.key");
        settings.remove("com.atlassian.upm:selfupdate.upm.uri");
        settings.remove("com.atlassian.upm:selfupdate.stub.uri");
        settings.remove("com.atlassian.upm:selfupdate.plugins.enabled");
        settings.remove("com.atlassian.upm:selfupdate.upm.post.uri");
    }
}

