/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.selfupdate;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginState;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.selfupdate.UpdateParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.HttpURLConnection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateController {
    private static final Logger log = LoggerFactory.getLogger(UpdateController.class);
    private final PluginAccessor pluginAccessor;
    private final PluginController pluginController;
    private final TransactionTemplate txTemplate;

    public UpdateController(PluginAccessor pluginAccessor, PluginController pluginController, TransactionTemplate txTemplate) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.pluginController = (PluginController)Preconditions.checkNotNull((Object)pluginController, (Object)"pluginController");
        this.txTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)txTemplate, (Object)"txTemplate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performUpdate(UpdateParameters params) throws PluginException {
        JarPluginArtifact pluginArtifact = new JarPluginArtifact(params.getJarToInstall());
        String installedPluginKey = (String)this.txTemplate.execute((TransactionCallback)new TransactionCallback<String>((PluginArtifact)pluginArtifact){
            final /* synthetic */ PluginArtifact val$pluginArtifact;
            {
                this.val$pluginArtifact = pluginArtifact;
            }

            public String doInTransaction() {
                Set installedKeys = UpdateController.this.pluginController.installPlugins(new PluginArtifact[]{this.val$pluginArtifact});
                if (installedKeys.isEmpty() || Iterables.getOnlyElement((Iterable)installedKeys) == null) {
                    throw new PluginException("Plugin failed to install: " + this.val$pluginArtifact.getName());
                }
                return (String)Iterables.getOnlyElement((Iterable)installedKeys);
            }
        });
        if (!installedPluginKey.equals(params.getExpectedPluginKey())) {
            String message = "Update task installed plugin with key \"" + installedPluginKey + "\", but the expected key was \"" + params.getExpectedPluginKey() + "\"";
            throw new PluginException(message);
        }
        log.warn("Installed UPM update");
        this.attemptToRestorePluginsEnabledState(params.getEnabledPluginKeys());
        if (params.getUpmCompletionUri() != null) {
            try {
                HttpURLConnection cxn = (HttpURLConnection)params.getUpmCompletionUri().toURL().openConnection();
                try {
                    cxn.setRequestMethod("POST");
                    cxn.setDoOutput(true);
                    cxn.getOutputStream().close();
                    int status = cxn.getResponseCode();
                    if (status != 200) {
                        log.warn("Received HTTP error " + status + " from UPM completion resource");
                    }
                }
                finally {
                    cxn.disconnect();
                }
            }
            catch (Exception e) {
                log.warn("Unable to post to UPM completion resource: " + e);
            }
        }
    }

    private void attemptToRestorePluginsEnabledState(Iterable<String> pluginKeys) {
        Plugin plugin;
        boolean shouldRetry = true;
        HashSet<String> failedPluginKeys = new HashSet<String>();
        HashSet pluginKeysRemaining = new LinkedHashSet<String>();
        for (String pluginKey : pluginKeys) {
            plugin = this.pluginAccessor.getPlugin(pluginKey);
            if (plugin == null || plugin.getPluginState() == PluginState.ENABLED) continue;
            pluginKeysRemaining.add(pluginKey);
        }
        while (shouldRetry && !Iterables.isEmpty(pluginKeysRemaining)) {
            boolean enabledSomePlugins = false;
            boolean failedToEnableSomePlugins = false;
            for (String pluginKey : ImmutableList.copyOf(pluginKeysRemaining)) {
                Plugin plugin2 = this.pluginAccessor.getPlugin(pluginKey);
                if (plugin2 == null) continue;
                boolean enabled = false;
                try {
                    this.pluginController.enablePlugins(new String[]{pluginKey});
                    this.pluginController.disablePlugin(pluginKey);
                    this.pluginController.enablePlugins(new String[]{pluginKey});
                    Plugin newState = this.pluginAccessor.getPlugin(pluginKey);
                    if (newState != null && newState.getPluginState() == PluginState.ENABLED) {
                        enabled = true;
                    }
                }
                catch (Exception e) {
                    log.debug(e.toString(), (Throwable)e);
                }
                if (enabled) {
                    enabledSomePlugins = true;
                    pluginKeysRemaining.remove(pluginKey);
                    failedPluginKeys.remove(pluginKey);
                    log.info("After updating UPM, the plugin \"{}\" became disabled. The plugin was successfully re-enabled.", (Object)pluginKey);
                    continue;
                }
                failedToEnableSomePlugins = true;
                failedPluginKeys.add(pluginKey);
            }
            shouldRetry = failedToEnableSomePlugins && enabledSomePlugins;
            pluginKeysRemaining = failedPluginKeys;
        }
        for (String failedPluginKey : failedPluginKeys) {
            plugin = this.pluginAccessor.getPlugin(failedPluginKey);
            log.warn("After updating UPM, the plugin \"{}\" became disabled. This may be due to a bug present in older product versions (UPM-3116). UPM failed to re-enable the plugin.", (Object)(plugin == null ? failedPluginKey : plugin.getName()));
        }
    }
}

