define('stride/token-status-flag', [
    'jquery',
    'jira/util/formatter',
    'jira/flag',
    'wrm/context-path',
    'jira/util/logger'
], function (
    jQuery,
    formatter,
    jiraFlag,
    contextPath,
    logger
) {
    var FLAG_ID = 'stride.token.disconnected.flag';
    var context = contextPath();

    function displayFlag(data) {
        // skip if user is already in configuration view or edit pages
        var section = jQuery('meta[name="admin.active.tab"]').attr("content");
        if (section === 'stride-project-configuration-link' || section === 'stride-site-configuration-link') {
            return;
        }

        // title and body
        var title = '';
        var body = !data.hasMore
            ? formatter.I18n.getText('stride.plugin.flag.disconnected.dialog.body.single',
                data.projectName, data.firstBrokenConversationName)
            : formatter.I18n.getText('stride.plugin.flag.disconnected.dialog.body.multiple');
        var links = '<div class="stride-flag-dismiss"><a href="' + context + data.linkToConfiguration + '">'
            + formatter.I18n.getText('stride.plugin.flag.disconnected.configuration.link.label')
            + '</a></div>';

        // create flag
        var flag = jiraFlag.showWarningMsg(title, body + links, {
            dismissalKey: FLAG_ID
        });
    }

    return function() {
        jQuery.ajax({
            url: context + '/rest/stride/1.0/conversation/disconnected',
            cache: false,
            statusCode: {
                200: displayFlag
            }
        }).error(function(data, textStatus) {
            logger.error('Request failed with: ' + textStatus);
        });
    }
});