/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.web;

import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.transformer.CharSequenceDownloadableResource;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformer;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.DimensionAwareTransformerUrlBuilder;
import com.atlassian.webresource.api.prebake.DimensionAwareWebResourceTransformerFactory;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

@Scanned
public class JsI18nDumpingTransformer
implements DimensionAwareWebResourceTransformerFactory {
    private static final String QUERY_KEY = "locale";
    private static final String HASH_KEY = "locale-hash";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final WebResourceIntegration webResourceIntegration;
    private final I18nResolver i18nResolver;

    public JsI18nDumpingTransformer(@ComponentImport WebResourceIntegration webResourceIntegration, @ComponentImport I18nResolver i18nResolver) {
        this.webResourceIntegration = webResourceIntegration;
        this.i18nResolver = i18nResolver;
    }

    public Dimensions computeDimensions() {
        List locales = StreamSupport.stream(this.webResourceIntegration.getSupportedLocales().spliterator(), false).map(Locale::toLanguageTag).collect(Collectors.toList());
        return Dimensions.empty().andExactly(QUERY_KEY, locales);
    }

    public DimensionAwareTransformerUrlBuilder makeUrlBuilder(TransformerParameters params) {
        return new JsI18nTransformerUrlBuilder();
    }

    public UrlReadingWebResourceTransformer makeResourceTransformer(TransformerParameters params) {
        return new JsI18nUrlReadingWebResourceTransformer();
    }

    private final class JsI18nUrlReadingWebResourceTransformer
    implements UrlReadingWebResourceTransformer {
        private JsI18nUrlReadingWebResourceTransformer() {
        }

        public DownloadableResource transform(TransformableResource transformableResource, QueryParams params) {
            final Locale locale = this.getLocaleFromQueryParams(params);
            return new CharSequenceDownloadableResource(transformableResource.nextResource()){

                protected CharSequence transform(CharSequence original) {
                    Map translations = JsI18nDumpingTransformer.this.i18nResolver.getAllTranslationsForPrefix("stride.plugin.fe.", locale);
                    try {
                        String json = StringEscapeUtils.escapeEcmaScript((String)OBJECT_MAPPER.writeValueAsString((Object)translations));
                        return original.toString().replace("{i18n}", json);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        private Locale getLocaleFromQueryParams(QueryParams params) {
            String localeKey = params.get(JsI18nDumpingTransformer.QUERY_KEY);
            if (!StringUtils.isBlank((String)localeKey)) {
                return Locale.forLanguageTag(localeKey);
            }
            return Locale.US;
        }
    }

    private final class JsI18nTransformerUrlBuilder
    implements DimensionAwareTransformerUrlBuilder {
        private JsI18nTransformerUrlBuilder() {
        }

        public void addToUrl(UrlBuilder urlBuilder) {
            String locale = JsI18nDumpingTransformer.this.webResourceIntegration.getLocale().toLanguageTag();
            this.addToUrl(urlBuilder, locale);
        }

        public void addToUrl(UrlBuilder urlBuilder, Coordinate coord) {
            String locale = coord.get(JsI18nDumpingTransformer.QUERY_KEY);
            this.addToUrl(urlBuilder, locale);
        }

        private void addToUrl(UrlBuilder urlBuilder, String locale) {
            urlBuilder.addToQueryString(JsI18nDumpingTransformer.QUERY_KEY, locale);
            urlBuilder.addToHash(JsI18nDumpingTransformer.HASH_KEY, (Object)JsI18nDumpingTransformer.this.webResourceIntegration.getI18nStateHash());
        }
    }
}

