/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.util.validation;

import com.atlassian.jira.plugins.stride.exception.ValidationConstraintException;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.commons.lang.StringUtils;

@Named
@ExportAsService
public class ValidationHelper {
    public static final String CONVERSATION_URL_PATTERN = "https://api.atlassian.com/site/[\\w-]+/conversation/[\\w-]+/message";

    private Validator getValidator() {
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        return validatorFactory.getValidator();
    }

    public boolean isConversationUrlValid(String conversationUrl) {
        return StringUtils.defaultString((String)conversationUrl).matches(CONVERSATION_URL_PATTERN);
    }

    public <T> void validate(T conversation) {
        Validator validator = this.getValidator();
        Set violations = validator.validate(conversation, new Class[0]);
        Map<String, Set<String>> errors = violations.stream().collect(Collectors.groupingBy(violation -> violation.getPropertyPath().toString(), Collectors.mapping(ConstraintViolation::getMessage, Collectors.toSet())));
        if (!errors.isEmpty()) {
            throw new ValidationConstraintException(errors);
        }
    }
}

