/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.util.validation;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.plugins.stride.util.validation.IssueStatusIds;
import java.util.Arrays;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.lang.StringUtils;

public class IssueStatusIdsValidator
implements ConstraintValidator<IssueStatusIds, String> {
    private StatusManager statusManager;

    public void initialize(IssueStatusIds constraintAnnotation) {
        this.statusManager = (StatusManager)ComponentAccessor.getComponent(StatusManager.class);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        String statusIdsNotNull = StringUtils.defaultString((String)value);
        String[] statusIdsArray = statusIdsNotNull.split(",");
        boolean allIdsAreValid = Arrays.stream(statusIdsArray).filter(StringUtils::isNotBlank).map(arg_0 -> ((StatusManager)this.statusManager).getStatus(arg_0)).allMatch(Objects::nonNull);
        return allIdsAreValid;
    }
}

