/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;

@ParametersAreNonnullByDefault
public final class StringHelper {
    private static final String ELLIPSIS = "...";
    private static final int ELLIPSIS_LENGTH = "...".length();

    private StringHelper() {
    }

    public static String parseConversationId(String conversationUrl) {
        String conversationId = StringHelper.findFirstGroup(conversationUrl, "/conversation/([\\w-]+)");
        return conversationId;
    }

    public static String parseCloudId(String conversationUrl) {
        String cloudId = StringHelper.findFirstGroup(conversationUrl, "/site/([\\w-]+)");
        return cloudId;
    }

    private static String findFirstGroup(String str, String regexp) {
        Pattern pattern = Pattern.compile(regexp);
        Matcher matcher = pattern.matcher(StringUtils.defaultString((String)str, (String)""));
        String token = null;
        if (matcher.find()) {
            token = matcher.group(1);
        }
        return token;
    }

    public static String truncateWithEllipsis(String text, int maxLength) {
        if (maxLength > ELLIPSIS_LENGTH && text.length() > maxLength) {
            return text.substring(0, maxLength - ELLIPSIS_LENGTH) + ELLIPSIS;
        }
        return text;
    }
}

