/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;

public final class I18nHelper {
    private static Supplier<I18nResolver> i18nResolverSupplier = I18nHelper.getMemoizedI18nResolverSupplier();

    private I18nHelper() {
    }

    public static String getText(String key) {
        return ((I18nResolver)i18nResolverSupplier.get()).getRawText(key);
    }

    @VisibleForTesting
    public static void resetCache() {
        i18nResolverSupplier = I18nHelper.getMemoizedI18nResolverSupplier();
    }

    private static Supplier<I18nResolver> getMemoizedI18nResolverSupplier() {
        return Suppliers.memoize(() -> (I18nResolver)ComponentAccessor.getOSGiComponentInstanceOfType(I18nResolver.class));
    }
}

