/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.util;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;

public final class HttpClientHelper {
    private static final int REQUEST_RETRY_COUNT = 3;
    private static final int REQUEST_TIMEOUT = 10000;
    private static final int RETRY_INTERVAL = 500;

    private HttpClientHelper() {
    }

    public static CloseableHttpClient createHttpClient() {
        return HttpClients.custom().useSystemProperties().setDefaultRequestConfig(RequestConfig.custom().setSocketTimeout(10000).build()).setRetryHandler((HttpRequestRetryHandler)new CustomRequestRetryHandler()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new CustomUnavailableRetryStrategy()).build();
    }

    private static class CustomRequestRetryHandler
    implements HttpRequestRetryHandler {
        private final DefaultHttpRequestRetryHandler delegate = new DefaultHttpRequestRetryHandler(3, true);

        private CustomRequestRetryHandler() {
        }

        public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
            if (exception instanceof SocketTimeoutException) {
                return true;
            }
            return this.delegate.retryRequest(exception, executionCount, context);
        }
    }

    private static class CustomUnavailableRetryStrategy
    implements ServiceUnavailableRetryStrategy {
        private CustomUnavailableRetryStrategy() {
        }

        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            return executionCount <= 3 && (response.getStatusLine().getStatusCode() == 500 || response.getStatusLine().getStatusCode() == 503 || response.getStatusLine().getStatusCode() == 504 || response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 403);
        }

        public long getRetryInterval() {
            return 500L;
        }
    }
}

