/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.upgrades;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.jira.plugins.stride.dao.ConversationDao;
import com.atlassian.jira.plugins.stride.dao.FilterDao;
import com.atlassian.jira.plugins.stride.dao.StrideConfigurationDao;
import com.atlassian.jira.plugins.stride.model.ao.ConversationAo;
import com.atlassian.jira.plugins.stride.model.ao.FilterAo;
import com.atlassian.jira.plugins.stride.model.ao.StrideConfigurationAo;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.model.dto.StrideConfigurationDto;
import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V1UpgradeTask
implements ActiveObjectsUpgradeTask {
    private final Logger LOGGER = LoggerFactory.getLogger(V1UpgradeTask.class);
    @VisibleForTesting
    public static final String DEFAULT_ACCESS_TOKEN_NAME = "Unknown access token name";
    @VisibleForTesting
    public static final String DEFAULT_CONVERSATION_AVATAR_URL = "https://static.stride.com/default-room-avatars/web/96pt/default_06-96.png";
    @VisibleForTesting
    public static final long DEFAULT_VERSION = 1L;
    @VisibleForTesting
    public static final String DEFAULT_FILTER_PREFIX = "Filter #";
    @VisibleForTesting
    public static final String DEFAULT_CREATED_BY = null;
    @VisibleForTesting
    public static final String DEFAULT_UPDATED_BY = null;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion oldModelVersion, ActiveObjects ao) {
        this.LOGGER.debug("Running upgrade task " + this.getClass().getName());
        ModelVersion newModelVersion = this.getModelVersion();
        if (oldModelVersion.isOlderThan(newModelVersion)) {
            this.LOGGER.debug("Upgrading data schema version from " + oldModelVersion + " to " + newModelVersion);
            this.runMigration(ao);
        } else {
            this.LOGGER.warn("Upgrading data schema from version " + oldModelVersion + " to " + newModelVersion + " is skipped. Current version is newer than the version of the upgrade task");
        }
    }

    private void runMigration(ActiveObjects ao) {
        StrideConfigurationDao configurationDao = new StrideConfigurationDao(ao);
        ConversationDao conversationDao = new ConversationDao(ao);
        FilterDao filterDao = new FilterDao(ao);
        ao.migrate(new Class[]{StrideConfigurationAo.class, ConversationAo.class, FilterAo.class});
        List<StrideConfigurationDto> configurations = configurationDao.findAll();
        for (StrideConfigurationDto configuration : configurations) {
            Long configurationId = configuration.getId();
            Date now = new Date();
            ConversationDto conversation = new ConversationDto(0L, configuration.getProjectId(), configuration.getAccessToken(), DEFAULT_ACCESS_TOKEN_NAME, configuration.getTokenStatus(), configuration.parseCloudId(), configuration.parseConversationId(), configuration.getConversationName(), DEFAULT_CONVERSATION_AVATAR_URL, DEFAULT_CREATED_BY, now, DEFAULT_UPDATED_BY, now, 1L);
            FilterDto filter = new FilterDto(0L, DEFAULT_FILTER_PREFIX + configurationId, configuration.getTrackIssueCreation(), configuration.getTrackIssueTransition(), configuration.getTrackIssueAssigneeChange(), configuration.getTrackCommentCreation(), configuration.getJqlFilter(), configuration.getTargetIssueStatusIds(), configuration.getSendNotificationAsCard());
            try {
                ConversationDto savedConversation = conversationDao.createOrUpdate(conversation);
                filter.setConversation(savedConversation);
                FilterDto savedFilter = filterDao.createOrUpdate(filter);
                this.LOGGER.debug("Configuration ID={} is successfully transformed to a Conversation ID={} and Filter ID={}", new Object[]{configurationId, savedConversation.getId(), savedFilter.getId()});
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred during the migration of the Stride configurations to conversations/filters. Configuration ID={}", (Object)configurationId, (Object)e);
                throw new RuntimeException(e);
            }
        }
    }
}

