/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.jira.plugins.stride.dao.StrideSettingsDao;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.service.AnalyticsService;
import com.atlassian.jira.plugins.stride.service.ConversationService;
import com.atlassian.jira.plugins.stride.service.StrideNotificationService;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class StrideSettingsService {
    private final StrideSettingsDao strideSettingsDao;
    private final AnalyticsService analyticsService;
    private final StrideNotificationService notificationService;
    private final ConversationService conversationService;

    @Inject
    public StrideSettingsService(StrideSettingsDao strideSettingsDao, AnalyticsService analyticsService, StrideNotificationService notificationService, ConversationService conversationService) {
        this.strideSettingsDao = strideSettingsDao;
        this.analyticsService = analyticsService;
        this.notificationService = notificationService;
        this.conversationService = conversationService;
    }

    public boolean areNotificationsMutedForProject(Long projectId) {
        return this.strideSettingsDao.areNotificationsMutedForProject(projectId);
    }

    public boolean areAllNotificationsMuted() {
        return this.strideSettingsDao.areAllNotificationsMuted();
    }

    public void muteProjectNotifications(Long projectId) {
        this.strideSettingsDao.muteProjectNotifications(projectId);
        this.analyticsService.projectMuted(projectId);
        List<ConversationDto> conversations = this.conversationService.findByProjectId(projectId);
        this.notificationService.sendNotificationOnProjectMuted(conversations);
    }

    public void unmuteProjectNotifications(Long projectId) {
        this.strideSettingsDao.unmuteProjectNotifications(projectId);
        this.analyticsService.projectUnmuted(projectId);
        List<ConversationDto> conversations = this.conversationService.findByProjectId(projectId);
        this.notificationService.sendNotificationOnProjectUnmuted(conversations);
    }

    public void unmuteAllNotifications() {
        this.strideSettingsDao.unmuteAllNotifications();
        this.analyticsService.allUnmuted();
        List<ConversationDto> conversations = this.getUniqueConversations();
        this.notificationService.sendNotificationOnAllUnmuted(conversations);
    }

    public void muteAllNotifications() {
        this.strideSettingsDao.muteAllNotifications();
        this.analyticsService.allMuted();
        List<ConversationDto> conversations = this.getUniqueConversations();
        this.notificationService.sendNotificationOnAllMuted(conversations);
    }

    private List<ConversationDto> getUniqueConversations() {
        Map conversationsByConversationId = this.conversationService.findAll().stream().collect(Collectors.toMap(ConversationDto::getConversationId, Function.identity(), (c1, c2) -> c1));
        Collection conversations = conversationsByConversationId.values();
        return ImmutableList.copyOf(conversations);
    }
}

