/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.plugins.stride.dao.ConversationDao;
import com.atlassian.jira.plugins.stride.exception.StrideApiRequestException;
import com.atlassian.jira.plugins.stride.model.DocumentSupplier;
import com.atlassian.jira.plugins.stride.model.StrideEventType;
import com.atlassian.jira.plugins.stride.model.TokenStatus;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.service.AdfBuilder;
import com.atlassian.jira.plugins.stride.service.AnalyticsService;
import com.atlassian.jira.plugins.stride.service.StrideApiService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.flag.FlagDismissalService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class StrideNotificationService {
    @VisibleForTesting
    public static final String FLAG_KEY = "stride.token.disconnected.flag";
    @VisibleForTesting
    public static final String HTTPS_PREFIX = "https://";
    private static final Logger LOGGER = LoggerFactory.getLogger(StrideNotificationService.class);
    private final FlagDismissalService flagDismissalService;
    private final ApplicationProperties applicationProperties;
    private final ProjectManager projectManager;
    private final AdfBuilder adfBuilder;
    private final StrideApiService strideApiService;
    private final AnalyticsService analyticsService;
    private final ConversationDao conversationDao;
    private final Queue<String> recentNotifications = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)10));

    @Inject
    public StrideNotificationService(@ComponentImport FlagDismissalService flagDismissalService, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport ProjectManager projectManager, AdfBuilder adfBuilder, StrideApiService strideApiService, AnalyticsService analyticsService, ConversationDao conversationDao) {
        this.flagDismissalService = flagDismissalService;
        this.applicationProperties = applicationProperties;
        this.projectManager = projectManager;
        this.adfBuilder = adfBuilder;
        this.strideApiService = strideApiService;
        this.analyticsService = analyticsService;
        this.conversationDao = conversationDao;
    }

    public List<String> recentNotificationIds() {
        return Collections.unmodifiableList(new ArrayList<String>(this.recentNotifications));
    }

    public void sendNotificationOnIssueCreation(List<FilterDto> filters, Issue issue) {
        this.sendNotificationsForFilters(filters, this.adfBuilder.buildForIssueCreation(issue), StrideEventType.ISSUE_CREATED, this.analyticsService::notificationIssueCreatedSucceeded, this.analyticsService::notificationIssueCreatedFailed);
    }

    public void sendNotificationOnIssueTransition(List<FilterDto> filters, Issue issue, ApplicationUser actor) {
        this.sendNotificationsForFilters(filters, this.adfBuilder.buildForIssueTransition(issue, actor), StrideEventType.ISSUE_TRANSITIONED, this.analyticsService::notificationIssueTransitionedSucceeded, this.analyticsService::notificationIssueTransitionedFailed);
    }

    public void sendNotificationOnIssueAssigneeChange(List<FilterDto> filters, Issue issue, ApplicationUser actor) {
        this.sendNotificationsForFilters(filters, this.adfBuilder.buildForAssigneeChange(issue, actor), StrideEventType.ISSUE_ASSIGNEE_CHANGED, this.analyticsService::notificationIssueAssigneeChangeSucceeded, this.analyticsService::notificationIssueAssigneeChangeFailed);
    }

    public void sendNotificationOnNewIssueComment(List<FilterDto> filters, Issue issue, Comment comment) {
        this.sendNotificationsForFilters(filters, this.adfBuilder.buildForNewComment(issue, comment), StrideEventType.COMMENT_CREATED, this.analyticsService::notificationIssueCommentCreatedSucceeded, this.analyticsService::notificationIssueCommentCreatedFailed);
    }

    public void sendNotificationOnConversationCreation(ConversationDto conversation, Project project) {
        this.adfBuilder.buildForConversationCreation(project).asJson().ifPresent(messageJson -> this.sendGenericNotification(conversation, (String)messageJson, StrideEventType.CONVERSATION_CREATED, this.analyticsService::notificationConversationCreatedSucceeded, this.analyticsService::notificationConversationCreatedFailed));
    }

    public void sendNotificationOnConversationChange(ConversationDto conversation, Project project) {
        this.adfBuilder.buildForConversationChange(project).asJson().ifPresent(messageJson -> this.sendGenericNotification(conversation, (String)messageJson, StrideEventType.CONVERSATION_CHANGED, this.analyticsService::notificationConversationUpdatedSucceeded, this.analyticsService::notificationConversationUpdatedFailed));
    }

    public void sendNotificationOnProjectMuted(List<ConversationDto> conversations) {
        this.sendNotificationsForConversations(conversations, conversation -> {
            long projectId = conversation.getProjectId();
            Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
            return this.adfBuilder.buildForProjectMuted(project);
        }, StrideEventType.PROJECT_NOTIFICATIONS_MUTED, this.analyticsService::notificationProjectMutedSucceeded, this.analyticsService::notificationProjectMutedFailed);
    }

    public void sendNotificationOnProjectUnmuted(List<ConversationDto> conversations) {
        this.sendNotificationsForConversations(conversations, conversation -> {
            long projectId = conversation.getProjectId();
            Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
            return this.adfBuilder.buildForProjectUnmuted(project);
        }, StrideEventType.PROJECT_NOTIFICATIONS_UNMUTED, this.analyticsService::notificationProjectUnmutedSucceeded, this.analyticsService::notificationProjectUnmutedFailed);
    }

    public void sendNotificationOnAllMuted(List<ConversationDto> conversations) {
        this.sendNotificationsForConversations(conversations, conversation -> this.adfBuilder.buildForAllMuted(), StrideEventType.ALL_NOTIFICATIONS_MUTED, this.analyticsService::notificationAllMutedSucceeded, this.analyticsService::notificationAllMutedFailed);
    }

    public void sendNotificationOnAllUnmuted(List<ConversationDto> conversations) {
        this.sendNotificationsForConversations(conversations, conversation -> this.adfBuilder.buildForAllUnmuted(), StrideEventType.ALL_NOTIFICATIONS_UNMUTED, this.analyticsService::notificationAllUnmutedSucceeded, this.analyticsService::notificationAllUnmutedFailed);
    }

    private void sendNotificationsForConversations(List<ConversationDto> conversations, Function<ConversationDto, DocumentSupplier> messageSupplier, StrideEventType eventType, BiConsumer<ConversationDto, String> successConsumer, BiConsumer<ConversationDto, Throwable> errorConsumer) {
        for (ConversationDto conversation : conversations) {
            messageSupplier.apply(conversation).asJson().ifPresent(messageJson -> this.sendGenericNotification(conversation, (String)messageJson, eventType, successConsumer, errorConsumer));
        }
    }

    public boolean isCardSupported() {
        return this.doesJiraUseHttpsBaseUrl();
    }

    private void sendNotificationsForFilters(List<FilterDto> filters, DocumentSupplier messageSupplier, StrideEventType eventType, BiConsumer<ConversationDto, String> successConsumer, BiConsumer<ConversationDto, Throwable> errorConsumer) {
        HashSet<String> notifiedConversationKeys = new HashSet<String>();
        for (FilterDto filter : filters) {
            boolean generateMessageWithCard;
            ConversationDto conversation = filter.getConversation();
            String conversationKey = conversation.getCloudId() + "|" + conversation.getConversationId();
            if (notifiedConversationKeys.contains(conversationKey)) {
                LOGGER.info("Skipping sending notification to conversation '{}' ID={} from filter '{}' ID={} because a notification to this room has already been sent for current event", new Object[]{conversation.getConversationName(), conversation.getConversationId(), filter.getName(), filter.getId()});
                continue;
            }
            notifiedConversationKeys.add(conversationKey);
            boolean userWantsToSendCards = filter.getSendNotificationAsCard();
            boolean bl = generateMessageWithCard = userWantsToSendCards && this.doesJiraUseHttpsBaseUrl();
            if (userWantsToSendCards && !generateMessageWithCard) {
                LOGGER.warn("Sending text notifications instead of cards because Jira base URL is not HTTPS-based");
            }
            Optional<String> messageJson = generateMessageWithCard ? messageSupplier.asJsonWithCard() : messageSupplier.asJson();
            messageJson.ifPresent(json -> this.sendGenericNotification(conversation, (String)json, eventType, successConsumer, errorConsumer));
        }
    }

    private boolean doesJiraUseHttpsBaseUrl() {
        String url = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        return url.startsWith(HTTPS_PREFIX);
    }

    private void sendGenericNotification(ConversationDto conversation, String messageJson, StrideEventType eventType, BiConsumer<ConversationDto, String> successConsumer, BiConsumer<ConversationDto, Throwable> errorConsumer) {
        ((CompletableFuture)this.strideApiService.sendNotificationAsync(conversation, messageJson, eventType).thenAccept(id -> {
            this.recentNotifications.add((String)id);
            successConsumer.accept(conversation, (String)id);
        })).exceptionally(e -> {
            LOGGER.error("Failed to send notification", e);
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof StrideApiRequestException && ((StrideApiRequestException)e).isTokenInvalid()) {
                this.markConversationAsDisconnected(conversation, (StrideApiRequestException)e);
            }
            errorConsumer.accept(conversation, (Throwable)e);
            return null;
        });
    }

    private void markConversationAsDisconnected(ConversationDto conversation, StrideApiRequestException exception) {
        this.flagDismissalService.resetFlagDismissals(FLAG_KEY);
        this.conversationDao.updateStatus(conversation.getId(), TokenStatus.DISCONNECTED);
        this.analyticsService.tokenDisconnected(conversation, Integer.toString(exception.getResponseStatus()));
    }
}

