/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.jira.plugins.stride.exception.StrideApiRequestException;
import com.atlassian.jira.plugins.stride.model.ConversationType;
import com.atlassian.jira.plugins.stride.model.StrideEventType;
import com.atlassian.jira.plugins.stride.model.analytics.Endpoint;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.ConversationInfoDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.service.AnalyticsService;
import com.atlassian.jira.plugins.stride.service.AsyncTaskRunner;
import com.atlassian.jira.plugins.stride.util.HttpClientHelper;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class StrideApiService {
    private static final String REQUEST_ID_HEADER = "X-Request-Id";
    private static final String TRACE_ID_HEADER = "X-Trace-Id";
    private static final Logger logger = LoggerFactory.getLogger(StrideApiService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final AsyncTaskRunner asyncTaskRunner;
    private final Supplier<CloseableHttpClient> httpClientSupplier;
    private final AnalyticsService analyticsService;

    @Inject
    public StrideApiService(AsyncTaskRunner asyncTaskRunner, AnalyticsService analyticsService) {
        this(asyncTaskRunner, HttpClientHelper::createHttpClient, analyticsService);
    }

    @VisibleForTesting
    StrideApiService(AsyncTaskRunner asyncTaskRunner, Supplier<CloseableHttpClient> httpClientSupplier, AnalyticsService analyticsService) {
        this.asyncTaskRunner = asyncTaskRunner;
        this.httpClientSupplier = httpClientSupplier;
        this.analyticsService = analyticsService;
    }

    public CompletableFuture<String> sendNotificationAsync(ConversationDto conversation, String messageJson, StrideEventType eventType) {
        return this.asyncTaskRunner.supplyAsync(() -> {
            Long conversationId = conversation.getId();
            Long projectId = conversation.getProjectId();
            Long filterId = conversation.getFirstFilterId();
            int jqlLength = StrideEventType.ISSUE_EVENTS.contains((Object)eventType) ? Optional.ofNullable(Iterables.getFirst(conversation.getFilters(), null)).map(FilterDto::getJql).map(String::length).orElse(0).intValue() : conversation.getFilters().stream().map(FilterDto::getJql).mapToInt(String::length).max().orElse(0);
            String userAgent = this.analyticsService.buildUserAgentString(projectId, conversationId, filterId, eventType, jqlLength);
            logger.debug("Sending notification for conversation ID={}", (Object)conversationId);
            return this.sendMessage(conversation.getCloudId(), conversation.getConversationId(), conversation.getAccessToken(), messageJson, conversationId, projectId, userAgent);
        });
    }

    /*
     * Exception decompiling
     */
    private String sendMessage(String cloudId, String conversationId, String accessToken, String messageJson, Long conversationEntityId, Long projectId, String userAgent) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Optional<ConversationInfoDto> getConversationInfo(String cloudId, String conversationId, String accessToken) {
        String apiUrl = "https://api.atlassian.com/site/" + cloudId + "/conversation/" + conversationId;
        HttpGet request = new HttpGet(apiUrl);
        request.setHeader("Authorization", "Bearer " + accessToken);
        Optional<ConversationInfoDto> conversationInfo = Optional.empty();
        try (CloseableHttpClient client = this.httpClientSupplier.get();
             CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            int responseStatusCode = response.getStatusLine().getStatusCode();
            String responseBody = this.getResponseBody(response);
            if (Response.Status.OK.getStatusCode() == responseStatusCode) {
                JsonNode responseNode = OBJECT_MAPPER.readTree(responseBody);
                if (responseNode == null) {
                    throw new IOException("Could not parse response: " + responseBody);
                }
                conversationInfo = Optional.ofNullable(responseNode.get("name")).map(JsonNode::textValue).map(conversationName -> {
                    String avatarUrl = Optional.ofNullable(responseNode.get("avatarUrl")).map(JsonNode::textValue).orElse(null);
                    String typeName = Optional.ofNullable(responseNode.get("type")).map(JsonNode::textValue).orElse(null);
                    ConversationType type = ConversationType.valueOfIgnoreCase(typeName);
                    return new ConversationInfoDto(conversationId, (String)conversationName, avatarUrl, type);
                });
                if (conversationInfo.isPresent()) {
                    this.analyticsService.apiRequestSucceeded(null, null, cloudId, conversationId, Endpoint.GET_CONVERSATION_INFO);
                } else {
                    this.analyticsService.genericError(null, null, cloudId, conversationId, "Conversation not found in Stride");
                }
            } else {
                String requestId = this.getFirstHeaderValue(response, REQUEST_ID_HEADER);
                String traceId = this.getFirstHeaderValue(response, TRACE_ID_HEADER);
                logger.warn("Failed to get conversation information. Site={}, Status={}, RequestId={}, TraceId={}", new Object[]{cloudId, responseStatusCode, requestId, traceId});
                this.handleUnexpectedRequestStatus(apiUrl, responseStatusCode, requestId, traceId, responseBody);
            }
        }
        catch (StrideApiRequestException e) {
            this.analyticsService.apiRequestFailed(null, null, cloudId, conversationId, Endpoint.GET_CONVERSATION_INFO, e.getResponseStatus(), e.getErrorPayload());
        }
        catch (Exception e) {
            logger.error("Failed to complete a request to Stride at {}", (Object)apiUrl, (Object)e);
            this.analyticsService.genericError(null, null, cloudId, conversationId, "Failed to complete a request to Stride");
        }
        return conversationInfo;
    }

    public String getTokenName(String accessToken) {
        String apiUrl = "https://api.atlassian.com/me";
        HttpGet request = new HttpGet(apiUrl);
        request.setHeader("Authorization", "Bearer " + accessToken);
        String tokenName = null;
        try (CloseableHttpClient client = this.httpClientSupplier.get();
             CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
            int responseStatusCode = response.getStatusLine().getStatusCode();
            String responseBody = this.getResponseBody(response);
            if (Response.Status.OK.getStatusCode() == responseStatusCode) {
                JsonNode responseNode = OBJECT_MAPPER.readTree(responseBody);
                if (responseNode == null) {
                    throw new IOException("Could not parse response: " + responseBody);
                }
                tokenName = Optional.ofNullable(responseNode.get("name")).map(JsonNode::asText).orElse(null);
                if (tokenName != null) {
                    this.analyticsService.apiRequestSucceeded(null, null, null, null, Endpoint.GET_TOKEN_NAME);
                } else {
                    this.analyticsService.genericError(null, null, null, null, "Token not found in Stride");
                }
            } else {
                String requestId = this.getFirstHeaderValue(response, REQUEST_ID_HEADER);
                String traceId = this.getFirstHeaderValue(response, TRACE_ID_HEADER);
                logger.warn("Failed to get token information. Status={}, RequestId={}, TraceId={}", new Object[]{responseStatusCode, requestId, traceId});
                this.handleUnexpectedRequestStatus(apiUrl, responseStatusCode, requestId, traceId, responseBody);
            }
        }
        catch (StrideApiRequestException e) {
            this.analyticsService.apiRequestFailed(null, null, null, null, Endpoint.GET_TOKEN_NAME, e.getResponseStatus(), e.getErrorPayload());
        }
        catch (Exception e) {
            logger.error("Failed to complete a request to Stride at {}", (Object)apiUrl, (Object)e);
            this.analyticsService.genericError(null, null, null, null, "Failed to complete a request to Stride");
        }
        return tokenName;
    }

    private String getResponseBody(CloseableHttpResponse response) {
        try {
            if (response != null && response.getEntity() != null && response.getEntity().getContent() != null) {
                return IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            logger.error("Error fetching API response body", (Throwable)e);
        }
        return "";
    }

    private String getFirstHeaderValue(CloseableHttpResponse response, String headerName) {
        String value = Optional.ofNullable(response.getFirstHeader(headerName)).map(Header::getValue).orElse(null);
        return value;
    }

    private void handleUnexpectedRequestStatus(String apiUrl, int responseStatus, String requestId, String traceId, String payload) {
        if (Response.Status.UNAUTHORIZED.getStatusCode() == responseStatus) {
            logger.warn("Token was not authorized by the Stride API. Conversation={}, Status={}, RequestId={}, TraceId={}", new Object[]{apiUrl, responseStatus, requestId, traceId});
            throw new StrideApiRequestException("Token was not authorized by the Stride API", apiUrl, responseStatus, payload, true);
        }
        if (Response.Status.FORBIDDEN.getStatusCode() == responseStatus) {
            logger.warn("Token was forbidden by the Stride API. Conversation={}, Status={}, RequestId={}, TraceId={}", new Object[]{apiUrl, responseStatus, requestId, traceId});
            throw new StrideApiRequestException("Token was forbidden by the Stride API", apiUrl, responseStatus, payload, true);
        }
        logger.error("Failed to make request to Stride at {}. Status={}, RequestId={}, TraceId={}", new Object[]{apiUrl, responseStatus, requestId, traceId});
        throw new StrideApiRequestException("Failed to make request to Stride", apiUrl, responseStatus, payload, false);
    }
}

