/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService
public class JqlService {
    private static final Logger logger = LoggerFactory.getLogger(JqlService.class);
    private static final Set<String> SIMPLE_JQL_FIELD_NAMES = Sets.newHashSet((Object[])new String[]{"issuetype", "type", "priority"});
    private final SearchService searchService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Inject
    public JqlService(@ComponentImport SearchService searchService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.searchService = searchService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Query parseJql(String jqlFilter) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        String jqlFilterNonNull = StringUtils.defaultString((String)jqlFilter);
        SearchService.ParseResult parseResult = this.searchService.parseQuery(loggedInUser, jqlFilterNonNull);
        Query query = null;
        if (parseResult.isValid()) {
            query = parseResult.getQuery();
        } else {
            logger.warn("Passed jql filter '{}' is invalid", (Object)jqlFilterNonNull);
        }
        return query;
    }

    public boolean isAdvancedJql(String jqlFilter) {
        if (!Strings.isNullOrEmpty((String)jqlFilter)) {
            Query fullQuery = this.parseJql(jqlFilter);
            if (!this.searchService.doesQueryFitFilterForm(this.jiraAuthenticationContext.getLoggedInUser(), fullQuery)) {
                return true;
            }
            if (fullQuery != null) {
                String[] parts = jqlFilter.split("(?i)\\bAND\\b|\\bOR\\b");
                return Stream.of(parts).anyMatch(part -> {
                    Query query = this.parseJql(part.trim());
                    if (query != null) {
                        String clauseName = query.getWhereClause().getName();
                        return !SIMPLE_JQL_FIELD_NAMES.contains(clauseName.toLowerCase());
                    }
                    return false;
                });
            }
        }
        return false;
    }
}

