/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IndexService {
    private static final Logger logger = LoggerFactory.getLogger(IndexService.class);
    private final IssueIndexingService indexingService;
    private final SearchService searchService;

    @Inject
    public IndexService(@ComponentImport IssueIndexingService indexingService, @ComponentImport SearchService searchService) {
        this.indexingService = indexingService;
        this.searchService = searchService;
    }

    public long countIssues(Query query) {
        long foundIssues = 0L;
        try {
            foundIssues = this.searchService.searchCountOverrideSecurity(null, query);
        }
        catch (SearchException e) {
            logger.warn("Failed to check JQL filter '{}'", (Object)query.getQueryString(), (Object)e);
        }
        return foundIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reIndexIssue(Issue issue) {
        boolean indexIssues = ImportUtils.isIndexIssues();
        ImportUtils.setIndexIssues((boolean)true);
        try {
            this.indexingService.reIndex(issue);
        }
        catch (IndexException e) {
            logger.error("An error occurred during the issue {} reindex", (Object)issue.getId(), (Object)e);
        }
        finally {
            ImportUtils.setIndexIssues((boolean)indexIssues);
        }
    }
}

