/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugins.stride.dao.FilterDao;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.service.IndexService;
import com.atlassian.jira.plugins.stride.service.JqlService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class FilterService {
    private static final Logger logger = LoggerFactory.getLogger(FilterService.class);
    private final StatusManager statusManager;
    private final FilterDao dao;
    private final JqlService jqlService;
    private final IndexService indexService;

    @Inject
    public FilterService(@ComponentImport StatusManager statusManager, FilterDao dao, JqlService jqlService, IndexService indexService) {
        this.statusManager = statusManager;
        this.dao = dao;
        this.jqlService = jqlService;
        this.indexService = indexService;
    }

    public Optional<FilterDto> findById(long id) {
        return this.dao.findById(id);
    }

    public List<FilterDto> findForIssueCreation(Issue issue) {
        List<FilterDto> matchingFilters = this.findMatchingFilters(issue, this.dao::findByProjectIdForIssueCreation, this.matchingJqlPredicate(issue));
        return matchingFilters;
    }

    public List<FilterDto> findForIssueTransition(Issue issue) {
        Predicate<FilterDto> predicate = this.matchingJqlPredicate(issue).and(this.matchingTrackedIssueStatusesPredicate(issue));
        List<FilterDto> matchingFilters = this.findMatchingFilters(issue, this.dao::findByProjectIdForIssueTransition, predicate);
        return matchingFilters;
    }

    public List<FilterDto> findForAssigneeChange(Issue issue) {
        List<FilterDto> matchingFilters = this.findMatchingFilters(issue, this.dao::findByProjectIdForIssueAssigneeChange, this.matchingJqlPredicate(issue));
        return matchingFilters;
    }

    public List<FilterDto> findForCommentCreation(Issue issue) {
        List<FilterDto> matchingFilters = this.findMatchingFilters(issue, this.dao::findByProjectIdForCommentCreation, this.matchingJqlPredicate(issue));
        return matchingFilters;
    }

    private List<FilterDto> findMatchingFilters(Issue issue, Function<Long, List<FilterDto>> filtersProducer, Predicate<FilterDto> predicate) {
        Long projectId = issue.getProjectId();
        List<FilterDto> filters = filtersProducer.apply(projectId);
        List<FilterDto> matchingFilters = filters.stream().filter(predicate).collect(Collectors.toList());
        return matchingFilters;
    }

    private Predicate<FilterDto> matchingJqlPredicate(Issue issue) {
        return filter -> {
            String jqlFilter = filter.getJql();
            Query filterQuery = this.jqlService.parseJql(jqlFilter);
            long foundIssues = 0L;
            if (filterQuery != null) {
                this.indexService.reIndexIssue(issue);
                Query query = JqlQueryBuilder.newBuilder((Query)filterQuery).where().and().issue(new String[]{issue.getKey()}).buildQuery();
                foundIssues = this.indexService.countIssues(query);
            }
            return foundIssues > 0L;
        };
    }

    private Predicate<FilterDto> matchingTrackedIssueStatusesPredicate(Issue issue) {
        Status issueStatus = issue.getStatus();
        return configuration -> {
            String statusIds = configuration.getTargetIssueStatusIds();
            boolean statusIsTracked = true;
            if (!StringUtils.isBlank((String)statusIds)) {
                List<Status> statuses = this.parseIssueStatusIds(statusIds);
                statusIsTracked = statuses.contains(issueStatus);
            }
            return statusIsTracked;
        };
    }

    private List<Status> parseIssueStatusIds(String statusIdsString) {
        String statusIdsNotNull = StringUtils.defaultString((String)statusIdsString);
        String[] statusIdsArray = statusIdsNotNull.split(",");
        List<Status> statuses = Arrays.stream(statusIdsArray).filter(StringUtils::isNotBlank).map(id -> {
            Status status = this.statusManager.getStatus(id);
            if (status == null) {
                logger.warn("Issue status with id {} is not found", id);
            }
            return status;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return statuses;
    }
}

