/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.stride.dao.ConversationDao;
import com.atlassian.jira.plugins.stride.dao.FilterDao;
import com.atlassian.jira.plugins.stride.exception.DuplicateConversationException;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.DisconnectedConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.service.AnalyticsService;
import com.atlassian.jira.plugins.stride.service.StrideNotificationService;
import com.atlassian.jira.plugins.stride.util.validation.ValidationHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.tuple.Pair;

@Named
public class ConversationService {
    private final ActiveObjects ao;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;
    private final GlobalPermissionManager globalPermissionManager;
    private final ConversationDao conversationDao;
    private final FilterDao filterDao;
    private final ValidationHelper validationHelper;
    private final StrideNotificationService notificationService;
    private final AnalyticsService analyticsService;

    @Inject
    public ConversationService(@ComponentImport ActiveObjects ao, @ComponentImport ProjectManager projectManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager, @ComponentImport GlobalPermissionManager globalPermissionManager, FilterDao filterDao, ValidationHelper validationHelper, StrideNotificationService notificationService, AnalyticsService analyticsService, ConversationDao conversationDao) {
        this.ao = ao;
        this.projectManager = projectManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.globalPermissionManager = globalPermissionManager;
        this.conversationDao = conversationDao;
        this.filterDao = filterDao;
        this.validationHelper = validationHelper;
        this.notificationService = notificationService;
        this.analyticsService = analyticsService;
    }

    public List<ConversationDto> findAll() {
        return this.conversationDao.findAll();
    }

    public Optional<ConversationDto> findById(long id) {
        return this.conversationDao.findById(id);
    }

    public List<ConversationDto> findByProjectId(long projectId) {
        return this.conversationDao.findByProjectId(projectId);
    }

    public ConversationDto createOrUpdate(ConversationDto dto) {
        return (ConversationDto)this.ao.executeInTransaction(() -> {
            this.validateConversation(dto);
            long currentDtoId = dto.getId();
            ConversationDto persistedConversation = this.conversationDao.createOrUpdate(dto);
            if (currentDtoId != 0L) {
                Set updatedFilterIds = dto.getFilters().stream().map(FilterDto::getId).collect(Collectors.toSet());
                this.filterDao.findByConversationId(currentDtoId).stream().map(FilterDto::getId).filter(filterId -> !updatedFilterIds.contains(filterId)).forEach(this.filterDao::delete);
            }
            for (FilterDto filter : dto.getFilters()) {
                if (currentDtoId == 0L) {
                    filter.setId(0L);
                }
                filter.setConversation(persistedConversation);
                this.filterDao.createOrUpdate(filter);
            }
            Optional<ConversationDto> freshDto = this.conversationDao.findById(persistedConversation.getId());
            freshDto.ifPresent(conversation -> {
                Project project = this.projectManager.getProjectObj(Long.valueOf(conversation.getProjectId()));
                if (currentDtoId != 0L) {
                    ConversationDto previousConversationState = this.conversationDao.findById(currentDtoId).orElse(null);
                    this.analyticsService.conversationUpdated(previousConversationState, (ConversationDto)conversation);
                    this.notificationService.sendNotificationOnConversationChange((ConversationDto)conversation, project);
                } else {
                    this.analyticsService.conversationCreated((ConversationDto)conversation);
                    this.notificationService.sendNotificationOnConversationCreation((ConversationDto)conversation, project);
                }
            });
            return freshDto.orElse(null);
        });
    }

    private void validateConversation(ConversationDto conversation) {
        Set<Long> existingConversationIds = this.conversationDao.getConversationIdsByCriteria(conversation.getCloudId(), conversation.getConversationId(), conversation.getProjectId());
        long currentDtoId = conversation.getId();
        Set duplicateConfigurationIds = existingConversationIds.stream().filter(id -> !id.equals(currentDtoId)).collect(Collectors.toSet());
        if (!duplicateConfigurationIds.isEmpty()) {
            throw new DuplicateConversationException((Long)duplicateConfigurationIds.iterator().next());
        }
        this.validationHelper.validate(conversation);
    }

    public int delete(long conversationId) {
        return (Integer)this.ao.executeInTransaction(() -> {
            this.filterDao.deleteByConversationId(conversationId);
            Optional<ConversationDto> conversationToDelete = this.conversationDao.findById(conversationId);
            int rowsUpdated = this.conversationDao.delete(conversationId);
            conversationToDelete.ifPresent(this.analyticsService::conversationDeleted);
            return rowsUpdated;
        });
    }

    public Optional<Long> findDuplicateConversation(Long projectId, String cloudId, String conversationId, @Nullable Long currentConfigurationId) {
        Set<Long> existingConversationIds = this.conversationDao.getConversationIdsByCriteria(cloudId, conversationId, projectId);
        return existingConversationIds.stream().filter(id -> !id.equals(currentConfigurationId)).findFirst();
    }

    public Optional<DisconnectedConversationDto> findDisconnected() {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        boolean hasGlobalPermission = this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
        int maximumDisconnectedResultSize = 2;
        List disconnectedConversations = this.conversationDao.findDisconnected().stream().map(config -> {
            Project project = this.projectManager.getProjectObj(Long.valueOf(config.getProjectId()));
            if (project == null) {
                return null;
            }
            return Pair.of((Object)config, (Object)project);
        }).filter(Objects::nonNull).filter(p -> hasGlobalPermission || this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, (Project)p.getRight(), user)).limit(maximumDisconnectedResultSize).collect(Collectors.toList());
        if (disconnectedConversations.isEmpty()) {
            return Optional.empty();
        }
        ConversationDto firstBrokenConfig = (ConversationDto)((Pair)disconnectedConversations.get(0)).getLeft();
        Project firstBrokenProject = (Project)((Pair)disconnectedConversations.get(0)).getRight();
        String linkToConfiguration = hasGlobalPermission ? "/stride/conversation/" + firstBrokenConfig.getId() : "/stride/project/" + firstBrokenProject.getKey() + "/conversation/" + firstBrokenConfig.getId();
        return Optional.of(new DisconnectedConversationDto(firstBrokenConfig.getConversationName(), firstBrokenProject.getName(), linkToConfiguration, disconnectedConversations.size() > 1));
    }
}

