/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class AsyncTaskRunner
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AsyncTaskRunner.class);
    private ExecutorService executor;

    public CompletableFuture<Void> runAsync(Runnable task) {
        return CompletableFuture.runAsync(task, this.executor);
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> task) {
        return CompletableFuture.supplyAsync(task, this.executor);
    }

    public void afterPropertiesSet() {
        this.executor = Executors.newWorkStealingPool();
    }

    public void destroy() throws Exception {
        this.executor.shutdown();
        boolean allTasksAreExecuted = this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        if (allTasksAreExecuted) {
            logger.debug("Stride AsyncTaskRunner is shut down successfully");
        } else {
            logger.error("Stride AsyncTaskRunner failed to shut down gracefully. Some task are still not executed");
        }
    }
}

