/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.analytics.api.services.AnalyticsConfigService;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugins.stride.dao.ConversationDao;
import com.atlassian.jira.plugins.stride.dao.FilterDao;
import com.atlassian.jira.plugins.stride.dao.StrideSettingsDao;
import com.atlassian.jira.plugins.stride.exception.StrideApiRequestException;
import com.atlassian.jira.plugins.stride.model.StrideEventType;
import com.atlassian.jira.plugins.stride.model.analytics.AllMutedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.AllUnmutedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ApiRequestFailedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ApiRequestSucceededEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ConversationCreatedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ConversationDeletedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ConversationUpdatedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.Endpoint;
import com.atlassian.jira.plugins.stride.model.analytics.EntityStats;
import com.atlassian.jira.plugins.stride.model.analytics.GenericErrorEvent;
import com.atlassian.jira.plugins.stride.model.analytics.NotificationFailedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.NotificationSucceededEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ProjectMutedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.ProjectUnmutedEvent;
import com.atlassian.jira.plugins.stride.model.analytics.TokenDisconnectedEvent;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.text.StrSubstitutor;

@Named
public class AnalyticsService {
    public static final String PLUGIN_KEY = "com.atlassian.plugins.stride-jira-plugin";
    @VisibleForTesting
    public static final String ANALYTICS_FORMAT_VERSION = "2";
    public static final String STRIDE_ANALYTICS_SUFFIX = "stride.analytics.suffix";
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;
    private final BuildUtilsInfo buildUtilsInfo;
    private final AnalyticsConfigService analyticsConfigService;
    private final HostApplication hostApplication;
    private final StrideSettingsDao strideSettingsDao;
    private final ConversationDao conversationDao;
    private final FilterDao filterDao;
    private final java.util.function.Supplier<String> pluginVersion;

    @Inject
    public AnalyticsService(@ComponentImport EventPublisher eventPublisher, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport BuildUtilsInfo buildUtilsInfo, @ComponentImport AnalyticsConfigService analyticsConfigService, StrideSettingsDao strideSettingsDao, ConversationDao conversationDao, FilterDao filterDao) {
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
        this.buildUtilsInfo = buildUtilsInfo;
        this.analyticsConfigService = analyticsConfigService;
        this.conversationDao = conversationDao;
        this.filterDao = filterDao;
        this.hostApplication = (HostApplication)ComponentAccessor.getComponent(HostApplication.class);
        this.strideSettingsDao = strideSettingsDao;
        this.pluginVersion = () -> ((Supplier)Suppliers.memoize(this::getPluginVersion)).get();
    }

    public void conversationCreated(ConversationDto dto) {
        this.eventPublisher.publish((Object)new ConversationCreatedEvent(this.pluginVersion.get(), dto, this.getEntityStats()));
    }

    public void conversationUpdated(ConversationDto previous, ConversationDto updated) {
        this.eventPublisher.publish((Object)new ConversationUpdatedEvent(this.pluginVersion.get(), updated, this.getEntityStats(), previous.getAccessTokenStatus()));
    }

    public void conversationDeleted(ConversationDto dto) {
        this.eventPublisher.publish((Object)new ConversationDeletedEvent(this.pluginVersion.get(), dto, this.getEntityStats()));
    }

    public void tokenDisconnected(ConversationDto dto, String reason) {
        this.eventPublisher.publish((Object)new TokenDisconnectedEvent(this.pluginVersion.get(), dto, reason, this.getEntityStats()));
    }

    public void notificationIssueCreatedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.issueCreated(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationIssueTransitionedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.issueTransitioned(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationIssueAssigneeChangeSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.issueAssigneeChanged(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationIssueCommentCreatedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.issueCommentCreated(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationIssueCreatedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.issueCreatedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationIssueTransitionedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.issueTransitionedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationIssueAssigneeChangeFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.issueAssigneeChangedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationIssueCommentCreatedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.issueCommentCreatedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationConversationCreatedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.conversationCreated(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationConversationUpdatedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.conversationUpdated(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationConversationCreatedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.conversationCreatedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationConversationUpdatedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.conversationUpdatedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationProjectMutedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.projectMuted(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationProjectMutedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.projectMutedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationProjectUnmutedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.projectUnmuted(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationProjectUnmutedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.projectUnmutedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationAllMutedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.allMuted(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationAllMutedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.allMutedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void notificationAllUnmutedSucceeded(ConversationDto dto, String messageId) {
        this.eventPublisher.publish((Object)NotificationSucceededEvent.allUnmuted(this.pluginVersion.get(), dto, messageId, this.getEntityStats()));
    }

    public void notificationAllUnmutedFailed(ConversationDto dto, Throwable e) {
        this.eventPublisher.publish((Object)NotificationFailedEvent.allUnmutedFailed(this.pluginVersion.get(), dto, this.unwrapStatus(e), e.getMessage(), this.getEntityStats()));
    }

    public void projectMuted(Long projectId) {
        this.eventPublisher.publish((Object)new ProjectMutedEvent(this.pluginVersion.get(), projectId, this.conversationDao.countAllByProjectId(projectId), this.getEntityStats()));
    }

    public void projectUnmuted(Long projectId) {
        this.eventPublisher.publish((Object)new ProjectUnmutedEvent(this.pluginVersion.get(), projectId, this.conversationDao.countAllByProjectId(projectId), this.getEntityStats()));
    }

    public void allMuted() {
        this.eventPublisher.publish((Object)new AllMutedEvent(this.pluginVersion.get(), this.getEntityStats()));
    }

    public void allUnmuted() {
        this.eventPublisher.publish((Object)new AllUnmutedEvent(this.pluginVersion.get(), this.getEntityStats()));
    }

    public void apiRequestSucceeded(Long conversationEntityId, Long projectId, String cloudId, String conversationId, Endpoint endpoint) {
        this.eventPublisher.publish((Object)new ApiRequestSucceededEvent(this.pluginVersion.get(), conversationEntityId, projectId, cloudId, conversationId, endpoint));
    }

    public void apiRequestFailed(Long conversationEntityId, Long projectId, String cloudId, String conversationId, Endpoint endpoint, int responseStatus, String payload) {
        this.eventPublisher.publish((Object)new ApiRequestFailedEvent(this.pluginVersion.get(), conversationEntityId, projectId, cloudId, conversationId, endpoint, responseStatus, payload));
    }

    public void genericError(Long conversationEntityId, Long projectId, String cloudId, String conversationId, String description) {
        this.eventPublisher.publish((Object)new GenericErrorEvent(this.pluginVersion.get(), conversationEntityId, projectId, cloudId, conversationId, description));
    }

    private Integer unwrapStatus(Throwable e) {
        if (e instanceof StrideApiRequestException) {
            return ((StrideApiRequestException)e).getResponseStatus();
        }
        return null;
    }

    private EntityStats getEntityStats() {
        Long mutedProjects = this.conversationDao.getConnectedProjectIds().stream().filter(this.strideSettingsDao::areNotificationsMutedForProject).count();
        return new EntityStats(this.conversationDao.countAll(), this.filterDao.countAll(), mutedProjects.intValue(), this.conversationDao.countDisconnected(), this.strideSettingsDao.areAllNotificationsMuted());
    }

    private String getPluginVersion() {
        Plugin plugin = this.pluginAccessor.getPlugin(PLUGIN_KEY);
        String version = plugin.getPluginInformation().getVersion();
        version = Boolean.valueOf(System.getProperty(ATLASSIAN_DEV_MODE, "false")) != false ? version + "-dev" : version + System.getProperty(STRIDE_ANALYTICS_SUFFIX, "");
        return version;
    }

    public String buildUserAgentString(Long projectId, Long conversationId, Long filterId, StrideEventType eventType, int jqlLength) {
        ImmutableMap params;
        String format;
        boolean canCollectAnalytics = this.analyticsConfigService.canCollectAnalytics();
        if (canCollectAnalytics) {
            String jiraVersion = this.buildUtilsInfo.getVersion();
            String instanceId = this.hostApplication.getId().get();
            EntityStats stats = this.getEntityStats();
            format = "Stride Jira Plugin/${formatVersion}/${pluginVersion} c:${jiraVersion};${instanceId};${projectId};${conversationId};${filterId} s:${totalConversations};${totalFilters};${mutedConversations};${disconnectedConversations};${allConversationsMuted} e:${eventTypeId} l:${jqlLength}";
            params = ImmutableMap.builder().put((Object)"formatVersion", (Object)ANALYTICS_FORMAT_VERSION).put((Object)"pluginVersion", (Object)this.pluginVersion.get()).put((Object)"jiraVersion", (Object)jiraVersion).put((Object)"instanceId", (Object)instanceId).put((Object)"projectId", (Object)String.valueOf(projectId)).put((Object)"conversationId", (Object)String.valueOf(conversationId)).put((Object)"filterId", (Object)String.valueOf(filterId != null ? filterId : 0L)).put((Object)"totalConversations", (Object)String.valueOf(stats.getTotal())).put((Object)"totalFilters", (Object)String.valueOf(stats.getTotalFilters())).put((Object)"mutedConversations", (Object)String.valueOf(stats.getMuted())).put((Object)"disconnectedConversations", (Object)String.valueOf(stats.getDisconnected())).put((Object)"allConversationsMuted", (Object)String.valueOf(stats.isAllMuted() ? 1 : 0)).put((Object)"eventTypeId", (Object)String.valueOf(eventType.ordinal())).put((Object)"jqlLength", (Object)String.valueOf(jqlLength)).build();
        } else {
            format = "Stride Jira Plugin/${formatVersion}/${pluginVersion}";
            params = ImmutableMap.builder().put((Object)"formatVersion", (Object)ANALYTICS_FORMAT_VERSION).put((Object)"pluginVersion", (Object)this.pluginVersion.get()).build();
        }
        String userAgent = StrSubstitutor.replace((Object)format, (Map)params);
        return userAgent;
    }
}

