/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.service;

import com.atlassian.adf.BlockNode;
import com.atlassian.adf.Document;
import com.atlassian.adf.block.BlockQuote;
import com.atlassian.adf.block.Paragraph;
import com.atlassian.adf.block.card.ApplicationCard;
import com.atlassian.adf.block.card.Lozenge;
import com.atlassian.adf.inline.Mark;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.plugins.stride.model.DocumentSupplier;
import com.atlassian.jira.plugins.stride.util.StringHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AdfBuilder {
    private static final int DEFAULT_MAX_NOTIFICATION_FIELD_LENGTH = 200;
    @VisibleForTesting
    static final String COMMENT_QUOTE_TEXT_COLOR = "#172b4d";
    private final ApplicationProperties applicationProperties;
    private final AvatarService avatarService;
    private final I18nHelper i18nHelper;

    @Inject
    public AdfBuilder(@ComponentImport(value="salApplicationProperties") ApplicationProperties applicationProperties, @ComponentImport AvatarService avatarService, @ComponentImport I18nHelper i18nHelper) {
        this.applicationProperties = applicationProperties;
        this.avatarService = avatarService;
        this.i18nHelper = i18nHelper;
    }

    public DocumentSupplier buildForIssueCreation(Issue issue) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeIssueCard -> {
            String prefix = this.i18nHelper.getText("stride.plugin.notification.issue.created", issue.getCreator().getDisplayName());
            Paragraph action = this.createActionDescription(prefix, issue, includeIssueCard == false);
            return this.createDocument(issue, (boolean)includeIssueCard, new BlockNode[]{action});
        }));
    }

    public DocumentSupplier buildForIssueTransition(Issue issue, ApplicationUser actor) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeIssueCard -> {
            String prefix = this.i18nHelper.getText("stride.plugin.notification.issue.transitioned", actor.getDisplayName());
            String transitionedTo = this.i18nHelper.getText("stride.plugin.notification.issue.transitioned.to");
            Paragraph action = (Paragraph)this.createActionDescription(prefix, issue, includeIssueCard == false).text(" " + transitionedTo + " " + issue.getStatus().getName());
            return this.createDocument(issue, (boolean)includeIssueCard, new BlockNode[]{action});
        }));
    }

    public DocumentSupplier buildForAssigneeChange(Issue issue, ApplicationUser actor) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeIssueCard -> {
            String message = issue.getAssignee() != null ? "stride.plugin.notification.issue.assigned" : "stride.plugin.notification.issue.unassigned";
            String prefix = this.i18nHelper.getText(message, actor.getDisplayName());
            Paragraph action = this.createActionDescription(prefix, issue, includeIssueCard == false);
            if (issue.getAssignee() != null) {
                String assignedTo = this.i18nHelper.getText("stride.plugin.notification.issue.assigned.to");
                action.text(" " + assignedTo + " " + issue.getAssignee().getDisplayName());
            }
            return this.createDocument(issue, (boolean)includeIssueCard, new BlockNode[]{action});
        }));
    }

    public DocumentSupplier buildForNewComment(Issue issue, Comment comment) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeIssueCard -> {
            ApplicationUser author = comment.getAuthorApplicationUser();
            String prefix = this.i18nHelper.getText("stride.plugin.notification.issue.commented", author.getDisplayName());
            Paragraph action = (Paragraph)this.createActionDescription(prefix, issue, includeIssueCard == false).text(":");
            String commentBody = StringHelper.truncateWithEllipsis(comment.getBody(), this.maxNotificationFieldLength());
            BlockQuote commentQuote = (BlockQuote)BlockQuote.blockQuote().paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)p.color(commentBody, COMMENT_QUOTE_TEXT_COLOR);
            });
            return this.createDocument(issue, (boolean)includeIssueCard, new BlockNode[]{action, commentQuote});
        }));
    }

    public DocumentSupplier buildForConversationCreation(Project project) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeIssueCard -> {
            Mark link = (Mark)Mark.link((String)this.projectUrl(project)).attribute("title", project.getKey());
            return (Document)Document.create((BlockNode[])new BlockNode[0]).paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)((Paragraph)p.text(this.i18nHelper.getText("stride.plugin.notification.conversation.created") + " ")).text(project.getName(), new Mark[]{link});
            });
        }));
    }

    public DocumentSupplier buildForConversationChange(Project project) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeIssueCard -> {
            Mark link = (Mark)Mark.link((String)this.projectUrl(project)).attribute("title", project.getKey());
            Document document = (Document)Document.create((BlockNode[])new BlockNode[0]).paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)((Paragraph)p.text(this.i18nHelper.getText("stride.plugin.notification.conversation.updated") + " ")).text(project.getName(), new Mark[]{link});
            });
            return document;
        }));
    }

    public DocumentSupplier buildForProjectMuted(Project project) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeCard -> {
            Mark link = (Mark)Mark.link((String)this.projectUrl(project)).attribute("title", project.getKey());
            Document document = (Document)Document.create((BlockNode[])new BlockNode[0]).paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)((Paragraph)p.text(this.i18nHelper.getText("stride.plugin.notification.project.muted") + " ")).text(project.getName(), new Mark[]{link});
            });
            return document;
        }));
    }

    public DocumentSupplier buildForProjectUnmuted(Project project) {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeCard -> {
            Mark link = (Mark)Mark.link((String)this.projectUrl(project)).attribute("title", project.getKey());
            Document document = (Document)Document.create((BlockNode[])new BlockNode[0]).paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)((Paragraph)p.text(this.i18nHelper.getText("stride.plugin.notification.project.unmuted") + " ")).text(project.getName(), new Mark[]{link});
            });
            return document;
        }));
    }

    public DocumentSupplier buildForAllMuted() {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeCard -> {
            String instanceName = this.jiraTitle();
            Mark link = (Mark)Mark.link((String)this.baseUrl()).attribute("title", instanceName);
            Document document = (Document)Document.create((BlockNode[])new BlockNode[0]).paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)((Paragraph)p.text(this.i18nHelper.getText("stride.plugin.notification.all.muted") + " ")).text(instanceName, new Mark[]{link});
            });
            return document;
        }));
    }

    public DocumentSupplier buildForAllUnmuted() {
        return new DocumentSupplier((Function<Boolean, Document>)((Function)includeCard -> {
            String instanceName = this.jiraTitle();
            Mark link = (Mark)Mark.link((String)this.baseUrl()).attribute("title", instanceName);
            Document document = (Document)Document.create((BlockNode[])new BlockNode[0]).paragraph(p -> {
                Paragraph cfr_ignored_0 = (Paragraph)((Paragraph)p.text(this.i18nHelper.getText("stride.plugin.notification.all.unmuted") + " ")).text(instanceName, new Mark[]{link});
            });
            return document;
        }));
    }

    private Document createDocument(Issue issue, boolean includeIssueCard, BlockNode ... nodes) {
        Document doc = Document.create((BlockNode[])nodes);
        if (includeIssueCard) {
            doc.card(this.buildCardForIssue(issue));
        }
        return doc;
    }

    private Paragraph createActionDescription(String prefix, Issue issue, boolean includeSummary) {
        Mark link = (Mark)Mark.link((String)this.issueUrl(issue)).attribute("title", issue.getKey());
        Paragraph p = (Paragraph)((Paragraph)Paragraph.paragraph().text(prefix + " ")).text(issue.getKey(), t -> t.mark(new Mark[]{link}));
        if (includeSummary) {
            ((Paragraph)p.text(" ")).text(StringHelper.truncateWithEllipsis(issue.getSummary(), this.maxNotificationFieldLength()), t -> t.mark(new Mark[]{link}));
        }
        return p;
    }

    private ApplicationCard buildCardForIssue(Issue issue) {
        String cardText = issue.getKey() + ": " + StringHelper.truncateWithEllipsis(issue.getSummary(), this.maxNotificationFieldLength());
        Project project = issue.getProjectObject();
        String projectName = project.getName();
        String projectAvatarUrl = this.avatarService.getProjectAvatarAbsoluteURL(project, Avatar.Size.defaultSize()).toString();
        IssueType issueType = issue.getIssueType();
        String issueTypeName = issueType.getName();
        String issueTypeIconUrl = this.baseUrl() + issueType.getIconUrl();
        Priority priority = issue.getPriority();
        String priorityName = priority.getName();
        String priorityIconUrl = this.baseUrl() + priority.getIconUrl();
        String statusName = issue.getStatus().getName();
        ApplicationUser assignee = issue.getAssignee();
        String assigneeDisplayName = assignee != null ? assignee.getDisplayName() : null;
        String assigneeAvatarUrl = assignee != null ? this.avatarService.getAvatarAbsoluteURL(assignee, assignee, Avatar.Size.defaultSize()).toString() : null;
        ApplicationCard card = ApplicationCard.card((String)cardText);
        card.attrs().link(this.issueUrl(issue)).context(projectName, projectAvatarUrl, projectName).detail(detail -> detail.title("Type").icon(issueTypeIconUrl, issueTypeName).text(issueTypeName)).detail(detail -> detail.title("Priority").icon(priorityIconUrl, priorityName).text(priorityName)).detail(detail -> detail.title("Status").lozenge(statusName, lozenge -> lozenge.appearance(Lozenge.Appearance._new).strong(Boolean.valueOf(false))));
        if (assignee != null) {
            card.attrs().detail(detail -> detail.title("Assignee").icon(assigneeAvatarUrl, assigneeDisplayName).text(assigneeDisplayName));
        }
        return card;
    }

    private String issueUrl(Issue issue) {
        return this.baseUrl() + "/browse/" + issue.getKey();
    }

    private String projectUrl(Project project) {
        return this.baseUrl() + "/projects/" + project.getKey();
    }

    private String baseUrl() {
        return this.applicationProperties.getString("jira.baseurl");
    }

    private String jiraTitle() {
        return this.applicationProperties.getString("jira.title");
    }

    private int maxNotificationFieldLength() {
        try {
            return Integer.parseInt(System.getProperty("STRIDE_MAX_NOTIFICATION_FIELD_LENGTH", Integer.toString(200)));
        }
        catch (NumberFormatException e) {
            return 200;
        }
    }
}

