/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.rest;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.plugins.stride.exception.AccessDeniedException;
import com.atlassian.jira.plugins.stride.exception.ForbiddenException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;

@Named
public class PermissionChecker {
    private final GlobalPermissionManager globalPermissionManager;
    private final PermissionManager permissionManager;

    @Inject
    public PermissionChecker(@ComponentImport GlobalPermissionManager globalPermissionManager, @ComponentImport PermissionManager permissionManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.permissionManager = permissionManager;
    }

    public void requireAdmin(ApplicationUser user, Project project) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user) && !this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user)) {
            throw new ForbiddenException();
        }
    }

    public void requireGlobalAdmin(ApplicationUser user) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            throw new ForbiddenException();
        }
    }

    public void requireAdminForPageView(ApplicationUser user, Project project, HttpServletRequest servletRequest) {
        if (!this.permissionManager.hasPermission(ProjectPermissions.ADMINISTER_PROJECTS, project, user)) {
            throw new AccessDeniedException(servletRequest);
        }
    }

    public void requireGlobalAdminForPageView(ApplicationUser user, HttpServletRequest servletRequest) {
        if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            throw new AccessDeniedException(servletRequest);
        }
    }
}

