/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.rest;

import com.atlassian.jira.plugins.stride.exception.ProjectNotFoundException;
import com.atlassian.jira.plugins.stride.exception.UserNotAuthenticatedException;
import com.atlassian.jira.plugins.stride.rest.PermissionChecker;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

@Scanned
@Path(value="/view")
@AnonymousAllowed
public class PageViewResource {
    private final TemplateRenderer templateRenderer;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionChecker permissionChecker;
    @Context
    private HttpServletRequest servletRequest;

    @Inject
    public PageViewResource(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ProjectManager projectManager, PermissionChecker permissionChecker) {
        this.templateRenderer = templateRenderer;
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
        this.permissionChecker = permissionChecker;
    }

    @Path(value="/project/{projectKey}")
    @GET
    @Produces(value={"text/html"})
    public Response projectView(@PathParam(value="projectKey") String projectKey) {
        this.requiresLoggedInUser();
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        Project project = this.getProject(projectKey);
        this.permissionChecker.requireAdminForPageView(user, project, this.servletRequest);
        return this.streamTemplate("templates/view-project-configurations.vm", project);
    }

    @Path(value="")
    @GET
    @Produces(value={"text/html"})
    public Response globalView() {
        this.requiresLoggedInUser();
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        this.permissionChecker.requireGlobalAdminForPageView(user, this.servletRequest);
        return this.streamTemplate("templates/view-site-configurations.vm", null);
    }

    private void requiresLoggedInUser() {
        if (!this.authenticationContext.isLoggedInUser()) {
            throw new UserNotAuthenticatedException(this.servletRequest);
        }
    }

    private Response streamTemplate(String templateName, Project project) {
        StreamingOutput stream = os -> {
            HashMap<String, Project> propertiesMap = new HashMap<String, Project>();
            if (project != null) {
                propertiesMap.put("project", project);
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(os));
            this.templateRenderer.render(templateName, propertiesMap, (Writer)writer);
            ((Writer)writer).flush();
        };
        return Response.ok((Object)stream).build();
    }

    private Project getProject(String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            throw new ProjectNotFoundException();
        }
        return project;
    }
}

