/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.rest;

import com.atlassian.jira.plugins.stride.exception.ConversationNotFoundException;
import com.atlassian.jira.plugins.stride.exception.DirectConversationNotSupportedException;
import com.atlassian.jira.plugins.stride.exception.DuplicateConversationException;
import com.atlassian.jira.plugins.stride.exception.ProjectChangeException;
import com.atlassian.jira.plugins.stride.exception.ProjectNotFoundException;
import com.atlassian.jira.plugins.stride.exception.RestException;
import com.atlassian.jira.plugins.stride.model.ConnectivityStatus;
import com.atlassian.jira.plugins.stride.model.ConversationType;
import com.atlassian.jira.plugins.stride.model.TokenStatus;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.ConversationInfoDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.model.rest.BootstrapConversationsSummary;
import com.atlassian.jira.plugins.stride.model.rest.ConversationDetails;
import com.atlassian.jira.plugins.stride.model.rest.ConversationRequest;
import com.atlassian.jira.plugins.stride.model.rest.ConversationSummary;
import com.atlassian.jira.plugins.stride.model.rest.EntityId;
import com.atlassian.jira.plugins.stride.model.rest.Filter;
import com.atlassian.jira.plugins.stride.model.rest.TokenValidationRequest;
import com.atlassian.jira.plugins.stride.model.rest.TokenValidationResponse;
import com.atlassian.jira.plugins.stride.rest.PermissionChecker;
import com.atlassian.jira.plugins.stride.service.ConversationService;
import com.atlassian.jira.plugins.stride.service.StrideApiService;
import com.atlassian.jira.plugins.stride.service.StrideNotificationService;
import com.atlassian.jira.plugins.stride.service.StrideSettingsService;
import com.atlassian.jira.plugins.stride.util.StringHelper;
import com.atlassian.jira.plugins.stride.util.validation.ValidationHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
@Path(value="/conversation")
public class ConversationResource {
    private static final Logger logger = LoggerFactory.getLogger(ConversationResource.class);
    private final ProjectManager projectManager;
    private final ApplicationProperties applicationProperties;
    private final JiraAuthenticationContext authenticationContext;
    private final UserManager userManager;
    private final StrideApiService strideApiService;
    private final StrideSettingsService strideSettingsService;
    private final StrideNotificationService strideNotificationService;
    private final ConversationService conversationService;
    private final PermissionChecker permissionChecker;
    private final ValidationHelper validationHelper;

    @Inject
    public ConversationResource(@ComponentImport ProjectManager projectManager, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport UserManager userManager, ConversationService conversationService, StrideApiService strideApiService, StrideNotificationService strideNotificationService, StrideSettingsService strideSettingsService, PermissionChecker permissionChecker, ValidationHelper validationHelper) {
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.userManager = userManager;
        this.conversationService = conversationService;
        this.strideSettingsService = strideSettingsService;
        this.strideApiService = strideApiService;
        this.strideNotificationService = strideNotificationService;
        this.permissionChecker = permissionChecker;
        this.validationHelper = validationHelper;
    }

    @Path(value="/bootstrap")
    @GET
    @Produces(value={"application/json"})
    public Response bootstrap(@QueryParam(value="projectKey") String projectKey) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            if (StringUtils.isNotBlank((String)projectKey)) {
                Project project = this.getProject(projectKey);
                this.permissionChecker.requireAdmin(user, project);
                boolean isAllMuted = this.strideSettingsService.areAllNotificationsMuted();
                boolean isProjectMuted = this.strideSettingsService.areNotificationsMutedForProject(project.getId());
                boolean isCardSupported = this.strideNotificationService.isCardSupported();
                String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
                List<ConversationSummary> summaryList = this.getProjectSummaries(project, isProjectMuted);
                return Response.ok((Object)new BootstrapConversationsSummary(summaryList, isProjectMuted, isAllMuted, ConnectivityStatus.CONNECTED, isCardSupported, baseUrl)).build();
            }
            this.permissionChecker.requireGlobalAdmin(user);
            List<ConversationSummary> summaryList = this.getGlobalSummaries();
            boolean isAllMuted = this.strideSettingsService.areAllNotificationsMuted();
            boolean isCardSupported = this.strideNotificationService.isCardSupported();
            String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
            return Response.ok((Object)new BootstrapConversationsSummary(summaryList, null, isAllMuted, ConnectivityStatus.CONNECTED, isCardSupported, baseUrl)).build();
        }
        catch (Throwable ex) {
            logger.error("Error while getting conversation list", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/disconnected")
    @GET
    @Produces(value={"application/json"})
    public Response getDisconnectedConversation() {
        return this.conversationService.findDisconnected().map(Response::ok).orElseGet(Response::noContent).build();
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response getDetails(@PathParam(value="id") long id) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            return this.conversationService.findById(id).map(dto -> {
                Project project = this.getProject(dto.getProjectId());
                this.permissionChecker.requireAdmin(user, project);
                return Response.ok((Object)new ConversationDetails(dto.getId(), project.getKey(), dto.getAccessToken(), this.rebuildApiUrl(dto.getCloudId(), dto.getConversationId()), dto.getConversationName(), dto.getConversationAvatarUrl(), dto.getAccessTokenName(), dto.getAccessTokenStatus(), this.getUserName(dto.getCreatedBy()), dto.getCreatedAt().getTime(), this.getUserName(dto.getUpdatedBy()), dto.getUpdatedAt().getTime(), dto.getVersion(), dto.getFilters().stream().map(this::fromDto).collect(Collectors.toList()))).build();
            }).orElseThrow(ConversationNotFoundException::new);
        }
        catch (Throwable ex) {
            logger.error("Error while getting conversation list", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createConversation(ConversationRequest conversation) {
        try {
            this.validationHelper.validate(conversation);
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            Project project = this.getProject(conversation.getProjectKey());
            this.permissionChecker.requireAdmin(user, project);
            ConversationDto newConversation = this.conversationService.createOrUpdate(this.toDto(conversation));
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new EntityId(newConversation.getId())).build();
        }
        catch (Throwable ex) {
            logger.error("Exception while creating conversation", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateConversation(@PathParam(value="id") long id, ConversationRequest conversation) {
        try {
            this.validationHelper.validate(conversation);
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            Project newProject = this.getProject(conversation.getProjectKey());
            this.permissionChecker.requireAdmin(user, newProject);
            ConversationDto originalConversation = this.conversationService.findById(id).orElseThrow(ConversationNotFoundException::new);
            if (originalConversation.getProjectId() != newProject.getId().longValue()) {
                throw new ProjectChangeException();
            }
            ConversationDto dto = this.toDto(conversation);
            dto.setId(id);
            this.conversationService.createOrUpdate(dto);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Throwable ex) {
            logger.error("Exception while updating conversation", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/{id}")
    @DELETE
    public Response deleteConversation(@PathParam(value="id") long id) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            ConversationDto conversation = this.conversationService.findById(id).orElseThrow(ConversationNotFoundException::new);
            Project project = this.getProject(conversation.getProjectId());
            this.permissionChecker.requireAdmin(user, project);
            this.conversationService.delete(conversation.getId());
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Throwable ex) {
            logger.error("Exception while deleting conversation", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/mute")
    @POST
    public Response muteConversations(@QueryParam(value="projectKey") String projectKey) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            boolean hasProject = StringUtils.isNotBlank((String)projectKey);
            if (hasProject) {
                Project project = this.getProject(projectKey);
                this.permissionChecker.requireAdmin(user, project);
                this.strideSettingsService.muteProjectNotifications(project.getId());
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            this.permissionChecker.requireGlobalAdmin(user);
            this.strideSettingsService.muteAllNotifications();
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Throwable ex) {
            logger.error("Exception while muting", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/unmute")
    @POST
    public Response unmuteConversations(@QueryParam(value="projectKey") String projectKey) {
        try {
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            boolean hasProject = StringUtils.isNotBlank((String)projectKey);
            if (hasProject) {
                Project project = this.getProject(projectKey);
                this.permissionChecker.requireAdmin(user, project);
                this.strideSettingsService.unmuteProjectNotifications(project.getId());
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            this.permissionChecker.requireGlobalAdmin(user);
            this.strideSettingsService.unmuteAllNotifications();
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Throwable ex) {
            logger.error("Exception while unmuting", ex);
            throw RestException.wrap(ex);
        }
    }

    @Path(value="/validate")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response validateConversation(TokenValidationRequest req) {
        try {
            this.validationHelper.validate(req);
            ApplicationUser user = this.authenticationContext.getLoggedInUser();
            Project project = this.getProject(req.getProjectKey());
            this.permissionChecker.requireAdmin(user, project);
            String cloudId = StringHelper.parseCloudId(req.getConversationUrl());
            String conversationId = StringHelper.parseConversationId(req.getConversationUrl());
            Optional<ConversationInfoDto> info = this.strideApiService.getConversationInfo(cloudId, conversationId, req.getAccessToken());
            if (!info.isPresent()) {
                throw new ConversationNotFoundException();
            }
            TokenValidationResponse response = new TokenValidationResponse(info.get().getName(), info.get().getAvatarUrl(), this.strideApiService.getTokenName(req.getAccessToken()));
            if (info.get().getType() != ConversationType.GROUP) {
                throw new DirectConversationNotSupportedException(response);
            }
            Optional<Long> duplicateConversationId = this.conversationService.findDuplicateConversation(project.getId(), cloudId, conversationId, req.getConversationId());
            if (duplicateConversationId.isPresent()) {
                throw new DuplicateConversationException(duplicateConversationId.get(), response);
            }
            return Response.ok((Object)response).build();
        }
        catch (Throwable ex) {
            logger.error("Exception while validating token", ex);
            throw RestException.wrap(ex);
        }
    }

    private String rebuildApiUrl(String cloudId, String conversationId) {
        return "https://api.atlassian.com/site/" + cloudId + "/conversation/" + conversationId + "/message";
    }

    private List<ConversationSummary> getGlobalSummaries() {
        return this.toSummaries(this.conversationService.findAll(), this.createProjectLoadingCache(), this.createProjectMutedCache());
    }

    private List<ConversationSummary> getProjectSummaries(Project project, boolean isMuted) {
        LoadingCache<Long, Project> projectLoader = this.createProjectLoadingCache();
        LoadingCache<Long, Boolean> projectMutedLoader = this.createProjectMutedCache();
        projectLoader.put((Object)project.getId(), (Object)project);
        projectMutedLoader.put((Object)project.getId(), (Object)isMuted);
        return this.toSummaries(this.conversationService.findByProjectId(project.getId()), projectLoader, projectMutedLoader);
    }

    private List<ConversationSummary> toSummaries(List<ConversationDto> dtos, LoadingCache<Long, Project> projectLoader, LoadingCache<Long, Boolean> projectMutedLoader) {
        return dtos.stream().map(dto -> {
            Project project = (Project)projectLoader.getUnchecked((Object)dto.getProjectId());
            boolean isMuted = (Boolean)projectMutedLoader.getUnchecked((Object)dto.getProjectId());
            return new ConversationSummary(dto.getId(), dto.getConversationName(), dto.getConversationAvatarUrl(), this.getConversationDeepLink(dto.getCloudId(), dto.getConversationId()), this.getUserName(dto.getCreatedBy()), dto.getCreatedAt().getTime(), this.getUserName(dto.getUpdatedBy()), dto.getUpdatedAt().getTime(), dto.getFilters() != null ? dto.getFilters().size() : 0, dto.getAccessTokenStatus(), project.getKey(), project.getName(), isMuted);
        }).collect(Collectors.toList());
    }

    private String getUserName(String userKey) {
        UserProfile user = this.userManager.getUserProfile(userKey);
        return user != null ? user.getFullName() : "";
    }

    private ConversationDto toDto(ConversationRequest e) {
        Project project = this.getProject(e.getProjectKey());
        String cloudId = StringHelper.parseCloudId(e.getConversationUrl());
        String conversationId = StringHelper.parseConversationId(e.getConversationUrl());
        ConversationInfoDto conv = this.strideApiService.getConversationInfo(cloudId, conversationId, e.getAccessToken()).orElseThrow(ConversationNotFoundException::new);
        ConversationDto dto = new ConversationDto(0L, project.getId(), e.getAccessToken(), this.strideApiService.getTokenName(e.getAccessToken()), TokenStatus.CONNECTED, cloudId, conversationId, conv.getName(), conv.getAvatarUrl(), null, null, this.authenticationContext.getLoggedInUser().getKey(), new Date(), e.getVersion() != null ? e.getVersion() : 0L);
        Optional.ofNullable(e.getFilters()).orElse(Collections.emptyList()).stream().map(ConversationResource::toFilterDto).forEach(f -> {
            f.setConversation(dto);
            dto.addFilter((FilterDto)f);
        });
        return dto;
    }

    private Project getProject(long projectId) {
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        if (project == null) {
            throw new ProjectNotFoundException();
        }
        return project;
    }

    private Project getProject(String projectKey) {
        Project project = this.projectManager.getProjectObjByKey(projectKey);
        if (project == null) {
            throw new ProjectNotFoundException();
        }
        return project;
    }

    private LoadingCache<Long, Project> createProjectLoadingCache() {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, Project>(){

            public Project load(Long projectId) {
                return ConversationResource.this.getProject(projectId);
            }
        });
    }

    private LoadingCache<Long, Boolean> createProjectMutedCache() {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Long, Boolean>(){

            public Boolean load(Long projectId) {
                return ConversationResource.this.strideSettingsService.areNotificationsMutedForProject(projectId);
            }
        });
    }

    private static FilterDto toFilterDto(Filter filter) {
        return new FilterDto(filter.getId(), filter.getName(), filter.isTrackIssueCreation(), filter.isTrackIssueTransition(), filter.isTrackIssueAssigneeChange(), filter.isTrackCommentCreation(), filter.getJqlFilter(), filter.getTargetIssueStatusIds(), filter.isSendNotificationAsCard());
    }

    private Filter fromDto(FilterDto dto) {
        return new Filter(dto.getId(), dto.getName(), dto.getJql(), dto.getTrackIssueCreation(), dto.getTrackIssueTransition(), dto.getTrackIssueAssigneeChange(), dto.getTrackCommentCreation(), dto.getTargetIssueStatusIds(), dto.getSendNotificationAsCard());
    }

    private String getConversationDeepLink(String cloudId, String conversationId) {
        return "https://applink.atlassian.com/stride/" + cloudId + "/chat/" + conversationId;
    }
}

