/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.model.dto;

import com.atlassian.jira.plugins.stride.model.StrideConfiguration;
import com.atlassian.jira.plugins.stride.model.TokenStatus;
import com.atlassian.jira.plugins.stride.model.ao.StrideConfigurationAo;
import com.atlassian.jira.plugins.stride.util.StringHelper;
import com.atlassian.jira.plugins.stride.util.validation.IssueStatusIds;
import com.atlassian.jira.plugins.stride.util.validation.ValidJql;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;

public class StrideConfigurationDto
implements StrideConfiguration {
    private Long id;
    @NotNull(message="Please select a project")
    private @NotNull(message="Please select a project") Long projectId;
    @NotBlank(message="Conversation URL may not be empty")
    @Pattern(regexp="https://api.atlassian.com/site/[\\w-]+/conversation/[\\w-]+/message", message="Conversation URL does not match pattern https://api.atlassian.com/site/<cloud-id>/conversation/<conversation-id>/message")
    private @NotBlank(message="Conversation URL may not be empty") @Pattern(regexp="https://api.atlassian.com/site/[\\w-]+/conversation/[\\w-]+/message", message="Conversation URL does not match pattern https://api.atlassian.com/site/<cloud-id>/conversation/<conversation-id>/message") String conversationUrl;
    @NotBlank(message="Access token may not be empty")
    private @NotBlank(message="Access token may not be empty") String accessToken;
    @NotBlank(message="Conversation cannot be resolved. Please, make sure to add valid Access token and URL")
    private @NotBlank(message="Conversation cannot be resolved. Please, make sure to add valid Access token and URL") String conversationName;
    private boolean trackIssueCreation;
    private boolean trackIssueTransition;
    private boolean trackIssueAssigneeChange;
    private boolean trackCommentCreation;
    @ValidJql(message="JQL query is not valid")
    private @ValidJql(message="JQL query is not valid") String jqlFilter;
    @IssueStatusIds(message="Target issue status IDs should be a comma-separated list of ids of the existing Jira statuses")
    private @IssueStatusIds(message="Target issue status IDs should be a comma-separated list of ids of the existing Jira statuses") String targetIssueStatusIds;
    private boolean sendNotificationAsCard;
    @NotNull(message="Token status may not be empty")
    private @NotNull(message="Token status may not be empty") TokenStatus tokenStatus;

    public static StrideConfigurationDto fromAo(StrideConfigurationAo configurationAo) {
        return new StrideConfigurationDto(configurationAo.getId(), configurationAo.getProjectId(), configurationAo.getConversationUrl(), configurationAo.getConversationToken(), configurationAo.getConversationName(), configurationAo.getTrackIssueCreation(), configurationAo.getTrackIssueTransition(), configurationAo.getTrackIssueAssigneeChange(), configurationAo.getTrackCommentCreation(), configurationAo.getJqlFilter(), configurationAo.getTargetIssueStatusIds(), configurationAo.getSendNotificationAsCard(), configurationAo.getTokenStatus());
    }

    public StrideConfigurationDto() {
    }

    public StrideConfigurationDto(Long id, Long projectId, String conversationUrl, String accessToken, String conversationName, boolean trackIssueCreation, boolean trackIssueTransition, boolean trackIssueAssigneeChange, boolean trackCommentCreation, String jqlFilter, String targetIssueStatusIds, boolean sendNotificationAsCard, TokenStatus tokenStatus) {
        this.id = id;
        this.projectId = projectId;
        this.conversationUrl = conversationUrl;
        this.accessToken = accessToken;
        this.conversationName = conversationName;
        this.trackIssueCreation = trackIssueCreation;
        this.trackIssueTransition = trackIssueTransition;
        this.trackIssueAssigneeChange = trackIssueAssigneeChange;
        this.trackCommentCreation = trackCommentCreation;
        this.jqlFilter = jqlFilter;
        this.targetIssueStatusIds = targetIssueStatusIds;
        this.sendNotificationAsCard = sendNotificationAsCard;
        this.tokenStatus = tokenStatus;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public String getConversationUrl() {
        return this.conversationUrl;
    }

    @Override
    public void setConversationUrl(String conversationUrl) {
        this.conversationUrl = conversationUrl;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public String getConversationName() {
        return this.conversationName;
    }

    @Override
    public void setConversationName(String conversationName) {
        this.conversationName = conversationName;
    }

    @Override
    public boolean getTrackIssueCreation() {
        return this.trackIssueCreation;
    }

    @Override
    public void setTrackIssueCreation(boolean trackIssueCreation) {
        this.trackIssueCreation = trackIssueCreation;
    }

    @Override
    public boolean getTrackIssueTransition() {
        return this.trackIssueTransition;
    }

    @Override
    public void setTrackIssueTransition(boolean trackIssueTransition) {
        this.trackIssueTransition = trackIssueTransition;
    }

    @Override
    public boolean getTrackIssueAssigneeChange() {
        return this.trackIssueAssigneeChange;
    }

    @Override
    public void setTrackIssueAssigneeChange(boolean trackIssueAssigneeChange) {
        this.trackIssueAssigneeChange = trackIssueAssigneeChange;
    }

    @Override
    public boolean getTrackCommentCreation() {
        return this.trackCommentCreation;
    }

    @Override
    public void setTrackCommentCreation(boolean trackCommentCreation) {
        this.trackCommentCreation = trackCommentCreation;
    }

    @Override
    public String getJqlFilter() {
        return this.jqlFilter;
    }

    @Override
    public void setJqlFilter(String jqlFilter) {
        this.jqlFilter = jqlFilter;
    }

    @Override
    public String getTargetIssueStatusIds() {
        return this.targetIssueStatusIds;
    }

    @Override
    public void setTargetIssueStatusIds(String targetIssueStatusIds) {
        this.targetIssueStatusIds = targetIssueStatusIds;
    }

    @Override
    public boolean getSendNotificationAsCard() {
        return this.sendNotificationAsCard;
    }

    @Override
    public void setSendNotificationAsCard(boolean sendNotificationAsCard) {
        this.sendNotificationAsCard = sendNotificationAsCard;
    }

    @Override
    public TokenStatus getTokenStatus() {
        return this.tokenStatus;
    }

    @Override
    public void setTokenStatus(TokenStatus tokenStatus) {
        this.tokenStatus = tokenStatus;
    }

    public String parseConversationId() {
        String conversationId = StringHelper.parseConversationId(this.getConversationUrl());
        return conversationId;
    }

    public String parseCloudId() {
        String cloudId = StringHelper.parseCloudId(this.getConversationUrl());
        return cloudId;
    }

    public Map<String, Object> toMapWithAoNames() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"PROJECT_ID", (Object)this.getProjectId()).put((Object)"CONVERSATION_URL", (Object)this.getConversationUrl()).put((Object)"CONVERSATION_TOKEN", (Object)this.getAccessToken()).put((Object)"CONVERSATION_NAME", (Object)this.getConversationName()).put((Object)"TRACK_ISSUE_CREATION", (Object)this.getTrackIssueCreation()).put((Object)"TRACK_ISSUE_TRANSITION", (Object)this.getTrackIssueTransition()).put((Object)"TRACK_ISSUE_ASSIGNEE_CHANGE", (Object)this.getTrackIssueAssigneeChange()).put((Object)"TRACK_COMMENT_CREATION", (Object)this.getTrackCommentCreation()).put((Object)"JQL_FILTER", (Object)this.getJqlFilter()).put((Object)"TARGET_ISSUE_STATUS_IDS", (Object)this.getTargetIssueStatusIds()).put((Object)"SEND_NOTIFICATION_AS_CARD", (Object)this.getSendNotificationAsCard()).put((Object)"TOKEN_STATUS", (Object)this.getTokenStatus());
        return mapBuilder.build();
    }

    public Map<String, Object> toMapWithJavaNames() {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder().put((Object)"projectId", (Object)this.getProjectId()).put((Object)"conversationUrl", (Object)this.getConversationUrl()).put((Object)"conversationToken", (Object)this.getAccessToken()).put((Object)"conversationName", (Object)this.getConversationName()).put((Object)"trackIssueCreation", (Object)this.getTrackIssueCreation()).put((Object)"trackIssueTransition", (Object)this.getTrackIssueTransition()).put((Object)"trackIssueAssigneeChange", (Object)this.getTrackIssueAssigneeChange()).put((Object)"trackCommentCreation", (Object)this.getTrackCommentCreation()).put((Object)"jqlFilter", (Object)this.getJqlFilter()).put((Object)"targetIssueStatusIds", (Object)this.getTargetIssueStatusIds()).put((Object)"sendNotificationAsCard", (Object)this.getSendNotificationAsCard()).put((Object)"tokenStatus", (Object)this.getTokenStatus());
        return mapBuilder.build();
    }
}

