/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.model.dto;

import com.atlassian.jira.plugins.stride.model.ao.FilterAo;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.util.validation.IssueStatusIds;
import com.atlassian.jira.plugins.stride.util.validation.ValidJql;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

public class FilterDto {
    public static final int FILTER_NAME_MAX_LENGTH = 255;
    public static final int JQL_MAX_LENGTH = 2000;
    private long id;
    @NotBlank(message="stride.plugin.validation.filter.name.empty")
    @Size(max=255, message="stride.plugin.validation.filter.name.length")
    private @NotBlank(message="stride.plugin.validation.filter.name.empty") @Size(max=255, message="stride.plugin.validation.filter.name.length") String name;
    private boolean trackIssueCreation;
    private boolean trackIssueTransition;
    private boolean trackIssueAssigneeChange;
    private boolean trackCommentCreation;
    @ValidJql(message="stride.plugin.validation.filter.jql.syntax")
    @Size(max=2000, message="stride.plugin.validation.filter.jql.length")
    private @ValidJql(message="stride.plugin.validation.filter.jql.syntax") @Size(max=2000, message="stride.plugin.validation.filter.jql.length") String jql;
    @IssueStatusIds(message="stride.plugin.validation.filter.targetIssueStatusIds")
    private @IssueStatusIds(message="stride.plugin.validation.filter.targetIssueStatusIds") String targetIssueStatusIds;
    private boolean sendNotificationAsCard;
    private ConversationDto conversation;

    public static FilterDto fromAo(FilterAo ao) {
        return new FilterDto(ao.getId(), ao.getName(), ao.getTrackIssueCreation(), ao.getTrackIssueTransition(), ao.getTrackIssueAssigneeChange(), ao.getTrackCommentCreation(), ao.getJql(), ao.getTargetIssueStatusIds(), ao.getSendNotificationAsCard());
    }

    public FilterDto() {
    }

    public FilterDto(long id, String name, boolean trackIssueCreation, boolean trackIssueTransition, boolean trackIssueAssigneeChange, boolean trackCommentCreation, String jql, String targetIssueStatusIds, boolean sendNotificationAsCard) {
        this.id = id;
        this.name = name;
        this.trackIssueCreation = trackIssueCreation;
        this.trackIssueTransition = trackIssueTransition;
        this.trackIssueAssigneeChange = trackIssueAssigneeChange;
        this.trackCommentCreation = trackCommentCreation;
        this.jql = jql;
        this.targetIssueStatusIds = targetIssueStatusIds;
        this.sendNotificationAsCard = sendNotificationAsCard;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean getTrackIssueCreation() {
        return this.trackIssueCreation;
    }

    public void setTrackIssueCreation(boolean trackIssueCreation) {
        this.trackIssueCreation = trackIssueCreation;
    }

    public boolean getTrackIssueTransition() {
        return this.trackIssueTransition;
    }

    public void setTrackIssueTransition(boolean trackIssueTransition) {
        this.trackIssueTransition = trackIssueTransition;
    }

    public boolean getTrackIssueAssigneeChange() {
        return this.trackIssueAssigneeChange;
    }

    public void setTrackIssueAssigneeChange(boolean trackIssueAssigneeChange) {
        this.trackIssueAssigneeChange = trackIssueAssigneeChange;
    }

    public boolean getTrackCommentCreation() {
        return this.trackCommentCreation;
    }

    public void setTrackCommentCreation(boolean trackCommentCreation) {
        this.trackCommentCreation = trackCommentCreation;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public String getTargetIssueStatusIds() {
        return this.targetIssueStatusIds;
    }

    public void setTargetIssueStatusIds(String targetIssueStatusIds) {
        this.targetIssueStatusIds = targetIssueStatusIds;
    }

    public boolean getSendNotificationAsCard() {
        return this.sendNotificationAsCard;
    }

    public void setSendNotificationAsCard(boolean sendNotificationAsCard) {
        this.sendNotificationAsCard = sendNotificationAsCard;
    }

    public ConversationDto getConversation() {
        return this.conversation;
    }

    public void setConversation(ConversationDto conversation) {
        this.conversation = conversation;
    }

    public Map<String, Object> toMapWithAoNames() {
        return ImmutableMap.builder().put((Object)"NAME", (Object)this.name).put((Object)"TRACK_ISSUE_CREATION", (Object)this.trackIssueCreation).put((Object)"TRACK_ISSUE_TRANSITION", (Object)this.trackIssueTransition).put((Object)"TRACK_ISSUE_ASSIGNEE_CHANGE", (Object)this.trackIssueAssigneeChange).put((Object)"TRACK_COMMENT_CREATION", (Object)this.trackCommentCreation).put((Object)"JQL", (Object)this.jql).put((Object)"TARGET_ISSUE_STATUS_IDS", (Object)this.targetIssueStatusIds).put((Object)"SEND_NOTIFICATION_AS_CARD", (Object)this.sendNotificationAsCard).put((Object)"CONVERSATION_ID", (Object)this.conversation.getId()).build();
    }

    public void populateAo(FilterAo ao) {
        ao.setName(this.name);
        ao.setTrackIssueAssigneeChange(this.trackIssueAssigneeChange);
        ao.setTrackIssueCreation(this.trackIssueCreation);
        ao.setTrackIssueTransition(this.trackIssueTransition);
        ao.setTrackCommentCreation(this.trackCommentCreation);
        ao.setJql(this.jql);
        ao.setTargetIssueStatusIds(this.targetIssueStatusIds);
        ao.setSendNotificationAsCard(this.sendNotificationAsCard);
    }
}

