/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.model.dto;

import com.atlassian.jira.plugins.stride.model.TokenStatus;
import com.atlassian.jira.plugins.stride.model.ao.ConversationAo;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

public class ConversationDto {
    public static final int ACCESS_TOKEN_MAX_LENGTH = 20;
    public static final int CLOUD_ID_MAX_LENGTH = 36;
    public static final int CONVERSATION_ID_MAX_LENGTH = 36;
    public static final int CONVERSATION_URL_MAX_LENGTH = 125;
    private long id;
    @Min(message="stride.plugin.validation.conversation.project", value=1L)
    private @Min(message="stride.plugin.validation.conversation.project", value=1L) long projectId;
    @NotBlank(message="stride.plugin.validation.conversation.accessToken.empty")
    @Size(max=20, message="stride.plugin.validation.conversation.accessToken.length")
    private @NotBlank(message="stride.plugin.validation.conversation.accessToken.empty") @Size(max=20, message="stride.plugin.validation.conversation.accessToken.length") String accessToken;
    @NotBlank(message="stride.plugin.validation.conversation.accessTokenName")
    private @NotBlank(message="stride.plugin.validation.conversation.accessTokenName") String accessTokenName;
    @NotNull(message="stride.plugin.validation.conversation.accessTokenStatus")
    private @NotNull(message="stride.plugin.validation.conversation.accessTokenStatus") TokenStatus accessTokenStatus;
    @NotBlank(message="stride.plugin.validation.conversation.cloudId.empty")
    @Size(max=36, message="stride.plugin.validation.conversation.cloudId.length")
    private @NotBlank(message="stride.plugin.validation.conversation.cloudId.empty") @Size(max=36, message="stride.plugin.validation.conversation.cloudId.length") String cloudId;
    @NotBlank(message="stride.plugin.validation.conversation.conversationId.empty")
    @Size(max=36, message="stride.plugin.validation.conversation.conversationId.length")
    private @NotBlank(message="stride.plugin.validation.conversation.conversationId.empty") @Size(max=36, message="stride.plugin.validation.conversation.conversationId.length") String conversationId;
    @NotBlank(message="stride.plugin.validation.conversation.conversationName")
    private @NotBlank(message="stride.plugin.validation.conversation.conversationName") String conversationName;
    @NotBlank(message="stride.plugin.validation.conversation.conversationAvatarUrl")
    private @NotBlank(message="stride.plugin.validation.conversation.conversationAvatarUrl") String conversationAvatarUrl;
    private String createdBy;
    private Date createdAt;
    private String updatedBy;
    @NotNull(message="stride.plugin.validation.conversation.updatedAt")
    private @NotNull(message="stride.plugin.validation.conversation.updatedAt") Date updatedAt;
    private long version;
    @Valid
    private List<FilterDto> filters = new ArrayList<FilterDto>();

    public static ConversationDto fromAo(ConversationAo ao) {
        return new ConversationDto(ao.getId(), ao.getProjectId(), ao.getAccessToken(), ao.getAccessTokenName(), ao.getAccessTokenStatus(), ao.getCloudId(), ao.getConversationId(), ao.getConversationName(), ao.getConversationAvatarUrl(), ao.getCreatedBy(), ao.getCreatedAt(), ao.getUpdatedBy(), ao.getUpdatedAt(), ao.getVersion());
    }

    public ConversationDto() {
    }

    public ConversationDto(long id, long projectId, String accessToken, String accessTokenName, TokenStatus accessTokenStatus, String cloudId, String conversationId, String conversationName, String conversationAvatarUrl, String createdBy, Date createdAt, String updatedBy, Date updatedAt, long version) {
        this.id = id;
        this.projectId = projectId;
        this.accessToken = accessToken;
        this.accessTokenName = accessTokenName;
        this.cloudId = cloudId;
        this.conversationId = conversationId;
        this.conversationName = conversationName;
        this.conversationAvatarUrl = conversationAvatarUrl;
        this.createdBy = createdBy;
        this.createdAt = createdAt;
        this.accessTokenStatus = accessTokenStatus;
        this.updatedBy = updatedBy;
        this.updatedAt = updatedAt;
        this.version = version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAccessTokenName() {
        return this.accessTokenName;
    }

    public void setAccessTokenName(String accessTokenName) {
        this.accessTokenName = accessTokenName;
    }

    public String getCloudId() {
        return this.cloudId;
    }

    public void setCloudId(String cloudId) {
        this.cloudId = cloudId;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getConversationName() {
        return this.conversationName;
    }

    public void setConversationName(String conversationName) {
        this.conversationName = conversationName;
    }

    public String getConversationAvatarUrl() {
        return this.conversationAvatarUrl;
    }

    public void setConversationAvatarUrl(String conversationAvatarUrl) {
        this.conversationAvatarUrl = conversationAvatarUrl;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TokenStatus getAccessTokenStatus() {
        return this.accessTokenStatus;
    }

    public void setAccessTokenStatus(TokenStatus accessTokenStatus) {
        this.accessTokenStatus = accessTokenStatus;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public List<FilterDto> getFilters() {
        return this.filters;
    }

    public void setFilters(List<FilterDto> filters) {
        this.filters = filters;
    }

    public boolean addFilter(FilterDto filter) {
        return this.filters.add(filter);
    }

    public boolean addFilters(List<FilterDto> filterDtos) {
        return this.filters.addAll(filterDtos);
    }

    public boolean removeFilter(FilterDto filter) {
        return this.filters.remove(filter);
    }

    public Long getFirstFilterId() {
        return Optional.ofNullable(this.filters).map(f -> (FilterDto)Iterables.getFirst((Iterable)f, null)).map(FilterDto::getId).orElse(null);
    }

    public Map<String, Object> toMapWithAoNames() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("PROJECT_ID", this.projectId);
        fields.put("ACCESS_TOKEN", this.accessToken);
        fields.put("ACCESS_TOKEN_NAME", this.accessTokenName);
        fields.put("CLOUD_ID", this.cloudId);
        fields.put("CONVERSATION_ID", this.conversationId);
        fields.put("CONVERSATION_NAME", this.conversationName);
        fields.put("CONVERSATION_AVATAR_URL", this.conversationAvatarUrl);
        fields.put("CREATED_BY", this.createdBy);
        fields.put("CREATED_AT", this.createdAt);
        fields.put("UPDATED_BY", this.updatedBy);
        fields.put("UPDATED_AT", this.updatedAt);
        fields.put("ACCESS_TOKEN_STATUS", (Object)this.accessTokenStatus);
        fields.put("VERSION", this.version);
        return fields;
    }

    public void populateAo(ConversationAo ao) {
        ao.setProjectId(this.projectId);
        ao.setAccessToken(this.accessToken);
        ao.setAccessTokenName(this.accessTokenName);
        ao.setCloudId(this.cloudId);
        ao.setConversationId(this.conversationId);
        ao.setConversationName(this.conversationName);
        ao.setConversationAvatarUrl(this.conversationAvatarUrl);
        ao.setUpdatedBy(this.updatedBy);
        ao.setUpdatedAt(this.updatedAt);
        ao.setAccessTokenStatus(this.accessTokenStatus);
    }
}

