/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.model.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.plugins.stride.model.analytics.AbstractCommonContextAttributes;
import com.atlassian.jira.plugins.stride.model.analytics.EntityStats;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Optional;

public final class NotificationSucceededEvent
extends AbstractCommonContextAttributes {
    private final String eventName;
    private final boolean card;
    private final String messageId;
    private final Map<String, Integer> stats;

    public static NotificationSucceededEvent issueCreated(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.issue.created.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent issueTransitioned(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.issue.transitioned.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent issueAssigneeChanged(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.issue.assignee.changed.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent issueCommentCreated(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.issue.comment.created.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent conversationCreated(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.conversation.created.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent conversationUpdated(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.conversation.updated.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent projectMuted(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.project.muted.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent projectUnmuted(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.project.unmuted.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent allMuted(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.all.muted.succeeded", dto, messageId, stats);
    }

    public static NotificationSucceededEvent allUnmuted(String pluginVersion, ConversationDto dto, String messageId, EntityStats stats) {
        return new NotificationSucceededEvent(pluginVersion, "jira.stride.notification.all.unmuted.succeeded", dto, messageId, stats);
    }

    private NotificationSucceededEvent(String pluginVersion, String eventName, ConversationDto dto, String messageId, EntityStats stats) {
        super(pluginVersion, dto.getId(), dto.getFirstFilterId(), dto.getProjectId(), dto.getCloudId(), dto.getConversationId());
        this.eventName = eventName;
        this.card = Optional.ofNullable(Iterables.getFirst(dto.getFilters(), null)).map(FilterDto::getSendNotificationAsCard).orElse(false);
        this.messageId = messageId;
        this.stats = stats.asMap();
    }

    public String getMessageId() {
        return this.messageId;
    }

    public boolean isCard() {
        return this.card;
    }

    public Map<String, Integer> getStats() {
        return this.stats;
    }

    @EventName
    public String getEventName() {
        return this.eventName;
    }
}

