/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.model.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.jira.plugins.stride.model.analytics.AbstractCommonContextAttributes;
import com.atlassian.jira.plugins.stride.model.analytics.EntityStats;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Optional;

public final class NotificationFailedEvent
extends AbstractCommonContextAttributes {
    private final String eventName;
    private final boolean card;
    private final Integer responseCode;
    private final String errorMessage;
    private final Map<String, Integer> stats;

    public static NotificationFailedEvent issueCreatedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.issue.created.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent issueTransitionedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.issue.transitioned.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent issueAssigneeChangedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.issue.assignee.changed.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent issueCommentCreatedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.issue.comment.created.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent conversationCreatedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.conversation.created.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent conversationUpdatedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.conversation.updated.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent projectMutedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.project.muted.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent projectUnmutedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.project.unmuted.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent allMutedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.all.muted.failed", dto, responseCode, errorMessage, stats);
    }

    public static NotificationFailedEvent allUnmutedFailed(String pluginVersion, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        return new NotificationFailedEvent(pluginVersion, "jira.stride.notification.all.unmuted.failed", dto, responseCode, errorMessage, stats);
    }

    private NotificationFailedEvent(String pluginVersion, String eventName, ConversationDto dto, Integer responseCode, String errorMessage, EntityStats stats) {
        super(pluginVersion, dto.getId(), dto.getFirstFilterId(), dto.getProjectId(), dto.getCloudId(), dto.getConversationId());
        this.eventName = eventName;
        this.card = Optional.ofNullable(Iterables.getFirst(dto.getFilters(), null)).map(FilterDto::getSendNotificationAsCard).orElse(false);
        this.responseCode = responseCode;
        this.errorMessage = errorMessage;
        this.stats = stats.asMap();
    }

    public boolean isCard() {
        return this.card;
    }

    public Integer getResponseCode() {
        return this.responseCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, Integer> getStats() {
        return this.stats;
    }

    @EventName
    public String getEventName() {
        return this.eventName;
    }
}

