/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.model;

import com.atlassian.adf.Document;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentSupplier {
    private static final Logger logger = LoggerFactory.getLogger(DocumentSupplier.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Supplier<Optional<String>> serialized = Suppliers.memoize(() -> this.serializeToJson((Document)documentSupplier.apply((Object)false)));
    private final Supplier<Optional<String>> serializedWithCard = Suppliers.memoize(() -> this.serializeToJson((Document)documentSupplier.apply((Object)true)));

    public DocumentSupplier(Function<Boolean, Document> documentSupplier) {
    }

    public Optional<String> asJson() {
        return (Optional)this.serialized.get();
    }

    public Optional<String> asJsonWithCard() {
        return (Optional)this.serializedWithCard.get();
    }

    private Optional<String> serializeToJson(Document payload) {
        try {
            String serializedPayload = OBJECT_MAPPER.writeValueAsString((Object)payload);
            logger.debug("Serialized object to json: {}", (Object)serializedPayload);
            return Optional.of(serializedPayload);
        }
        catch (IOException e) {
            logger.error("Failed to serialize object to json: {}", (Object)payload);
            return Optional.empty();
        }
    }
}

