/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.exception;

import com.atlassian.jira.plugins.stride.model.rest.ApiError;
import com.atlassian.jira.plugins.stride.model.rest.TokenValidationResponse;
import com.atlassian.jira.plugins.stride.util.I18nHelper;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public class DuplicateConversationException
extends WebApplicationException {
    private final Long duplicateConversationId;
    private final TokenValidationResponse conversation;

    public DuplicateConversationException(Long duplicateConversationIds) {
        this(duplicateConversationIds, null);
    }

    public DuplicateConversationException(Long duplicateConversationId, TokenValidationResponse conversation) {
        this.duplicateConversationId = duplicateConversationId;
        this.conversation = conversation;
    }

    public Response getResponse() {
        ApiError error = new ApiError("stride.plugin.rest.error.duplicate.conversation", I18nHelper.getText("stride.plugin.rest.error.duplicate.conversation")).addAttribute("duplicateConversationId", this.duplicateConversationId);
        if (this.conversation != null) {
            error.addAttribute("conversation", this.conversation);
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).type("application/json").entity(error.asMap()).build();
    }

    public String getMessage() {
        return "stride.plugin.rest.error.duplicate.conversation";
    }

    public Long getDuplicateConversationId() {
        return this.duplicateConversationId;
    }

    public TokenValidationResponse getConversation() {
        return this.conversation;
    }
}

