/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.event;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.jira.plugins.stride.service.AsyncTaskRunner;
import com.atlassian.jira.plugins.stride.service.FilterService;
import com.atlassian.jira.plugins.stride.service.StrideNotificationService;
import com.atlassian.jira.plugins.stride.service.StrideSettingsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class IssueEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(IssueEventListener.class);
    private final EventPublisher eventPublisher;
    private final StrideNotificationService strideNotificationService;
    private final AsyncTaskRunner asyncTaskRunner;
    private final StrideSettingsService strideSettingsService;
    private final FilterService filterService;
    public static final Set<Long> ISSUE_TRANSITIONED_EVENT_IDS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Long[]{EventType.ISSUE_WORKSTARTED_ID, EventType.ISSUE_WORKSTOPPED_ID, EventType.ISSUE_RESOLVED_ID, EventType.ISSUE_REOPENED_ID, EventType.ISSUE_CLOSED_ID, EventType.ISSUE_GENERICEVENT_ID}));

    @Inject
    public IssueEventListener(@ComponentImport EventPublisher eventPublisher, StrideNotificationService strideNotificationService, AsyncTaskRunner asyncTaskRunner, StrideSettingsService strideSettingsService, FilterService filterService) {
        this.eventPublisher = eventPublisher;
        this.strideNotificationService = strideNotificationService;
        this.asyncTaskRunner = asyncTaskRunner;
        this.strideSettingsService = strideSettingsService;
        this.filterService = filterService;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent event) {
        this.asyncTaskRunner.runAsync(() -> this.handleIssueEvent(event));
    }

    private void handleIssueEvent(IssueEvent event) {
        boolean skipProcessing;
        Issue issue = event.getIssue();
        Long projectId = issue.getProjectId();
        boolean bl = skipProcessing = this.strideSettingsService.areAllNotificationsMuted() || this.strideSettingsService.areNotificationsMutedForProject(projectId);
        if (!skipProcessing) {
            if (this.isIssueCreatedEvent(event)) {
                List<FilterDto> filters = this.filterService.findForIssueCreation(issue);
                this.strideNotificationService.sendNotificationOnIssueCreation(filters, issue);
            } else if (this.isIssueTransitionedEvent(event)) {
                List<FilterDto> filters = this.filterService.findForIssueTransition(issue);
                this.strideNotificationService.sendNotificationOnIssueTransition(filters, issue, event.getUser());
            } else if (this.isIssueAssigneeChangedEvent(event)) {
                List<FilterDto> filters = this.filterService.findForAssigneeChange(issue);
                this.strideNotificationService.sendNotificationOnIssueAssigneeChange(filters, issue, event.getUser());
            } else if (this.isIssueCommentedEvent(event)) {
                List<FilterDto> filters = this.filterService.findForCommentCreation(issue);
                Comment comment = event.getComment();
                this.strideNotificationService.sendNotificationOnNewIssueComment(filters, issue, comment);
            }
        }
    }

    private boolean isIssueCreatedEvent(IssueEvent event) {
        Long eventTypeId = this.getEventTypeId(event);
        return EventType.ISSUE_CREATED_ID.equals(eventTypeId);
    }

    private boolean isIssueAssigneeChangedEvent(IssueEvent event) {
        Long eventTypeId = this.getEventTypeId(event);
        boolean isAssigneeChangedEvent = EventType.ISSUE_ASSIGNED_ID.equals(eventTypeId);
        boolean isIssueUpdatedEvent = EventType.ISSUE_UPDATED_ID.equals(eventTypeId) && this.getChangedFields(event).contains("assignee");
        boolean isAssigneeChanged = isAssigneeChangedEvent || isIssueUpdatedEvent;
        return isAssigneeChanged;
    }

    private boolean isIssueCommentedEvent(IssueEvent event) {
        Long eventTypeId = this.getEventTypeId(event);
        return EventType.ISSUE_COMMENTED_ID.equals(eventTypeId);
    }

    private boolean isIssueTransitionedEvent(IssueEvent event) {
        Long eventTypeId = this.getEventTypeId(event);
        return ISSUE_TRANSITIONED_EVENT_IDS.contains(eventTypeId);
    }

    private Long getEventTypeId(IssueEvent event) {
        return event.getEventTypeId();
    }

    private Set<String> getChangedFields(IssueEvent event) {
        List<GenericValue> childChangeItem;
        HashSet<String> changedFields = new HashSet<String>();
        Long eventTypeId = this.getEventTypeId(event);
        if (EventType.ISSUE_UPDATED_ID.equals(eventTypeId) && (childChangeItem = this.getChangeItems(event)) != null) {
            for (GenericValue changeItem : childChangeItem) {
                Object newValue;
                String changedField = changeItem.get("field").toString();
                Object oldValue = changeItem.get("oldvalue");
                boolean isFieldChanged = !Objects.equal((Object)oldValue, (Object)(newValue = changeItem.get("newvalue")));
                if (!isFieldChanged) continue;
                changedFields.add(changedField);
            }
        }
        return changedFields;
    }

    private List<GenericValue> getChangeItems(IssueEvent event) {
        List changeItems = null;
        try {
            changeItems = event.getChangeLog().getRelated("ChildChangeItem");
        }
        catch (GenericEntityException e) {
            log.error("Failed to get change items from the event", (Throwable)e);
        }
        return changeItems;
    }
}

