/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.dao;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class StrideSettingsDao {
    public static final String STRIDE_SETTINGS_NAMESPACE = "com.atlassian.plugins:stride-jira-plugin";
    public static final String PROJECT_NOTIFICATIONS_MUTED_PREFIX = "project.notifications.muted.";
    public static final String PROJECT_NOTIFICATIONS_MUTED_ALL_KEY = "project.notifications.muted.all";
    private final PluginSettingsFactory pluginSettingsFactory;

    @Inject
    public StrideSettingsDao(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public boolean areNotificationsMutedForProject(Long projectId) {
        String key = this.buildMuteProjectNotificationsKey(projectId);
        Object value = this.getStrideSettings().get(key);
        return value != null;
    }

    public boolean areAllNotificationsMuted() {
        Object value = this.getStrideSettings().get(PROJECT_NOTIFICATIONS_MUTED_ALL_KEY);
        return value != null;
    }

    public void unmuteProjectNotifications(Long projectId) {
        String key = this.buildMuteProjectNotificationsKey(projectId);
        this.getStrideSettings().remove(key);
    }

    public void muteProjectNotifications(Long projectId) {
        String key = this.buildMuteProjectNotificationsKey(projectId);
        this.getStrideSettings().put(key, (Object)"muted");
    }

    public void unmuteAllNotifications() {
        this.getStrideSettings().remove(PROJECT_NOTIFICATIONS_MUTED_ALL_KEY);
    }

    public void muteAllNotifications() {
        this.getStrideSettings().put(PROJECT_NOTIFICATIONS_MUTED_ALL_KEY, (Object)"muted");
    }

    private String buildMuteProjectNotificationsKey(Long projectId) {
        return PROJECT_NOTIFICATIONS_MUTED_PREFIX + projectId;
    }

    private PluginSettings getStrideSettings() {
        return this.pluginSettingsFactory.createSettingsForKey(STRIDE_SETTINGS_NAMESPACE);
    }
}

