/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.stride.model.ao.StrideConfigurationAo;
import com.atlassian.jira.plugins.stride.model.dto.StrideConfigurationDto;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class StrideConfigurationDao {
    private final ActiveObjects ao;

    @Inject
    public StrideConfigurationDao(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public List<StrideConfigurationDto> findAll() {
        StrideConfigurationAo[] configurationAos = (StrideConfigurationAo[])this.ao.find(StrideConfigurationAo.class);
        List<StrideConfigurationDto> configurationDtos = this.toDtoList(configurationAos);
        return configurationDtos;
    }

    private Optional<StrideConfigurationDto> toDto(StrideConfigurationAo configurationAo) {
        return Optional.ofNullable(configurationAo).map(StrideConfigurationDto::fromAo);
    }

    private List<StrideConfigurationDto> toDtoList(StrideConfigurationAo[] aoArray) {
        return Arrays.stream(aoArray).map(this::toDto).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

