/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.stride.model.ao.ConversationAo;
import com.atlassian.jira.plugins.stride.model.ao.FilterAo;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;

@Named
public class FilterDao {
    private final ActiveObjects ao;

    @Inject
    public FilterDao(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public int countAll() {
        return this.ao.count(FilterAo.class);
    }

    private FilterAo findAoById(long id) {
        return (FilterAo)this.ao.get(FilterAo.class, (Object)id);
    }

    public Optional<FilterDto> findById(long id) {
        FilterAo filterAo = this.findAoById(id);
        Optional<FilterDto> filterDto = this.toDto(filterAo);
        return filterDto;
    }

    public List<FilterDto> findByConversationId(long conversationId) {
        FilterAo[] aos = (FilterAo[])this.ao.find(FilterAo.class, Query.select().where("CONVERSATION_ID = ?", new Object[]{conversationId}).order("ID ASC"));
        List<FilterDto> dtos = this.toDtoList(aos);
        return dtos;
    }

    public List<FilterDto> findByProjectIdForIssueCreation(long projectId) {
        return this.findByProjectIdAndFlagInConnectedConversations(projectId, "TRACK_ISSUE_CREATION");
    }

    public List<FilterDto> findByProjectIdForIssueTransition(long projectId) {
        return this.findByProjectIdAndFlagInConnectedConversations(projectId, "TRACK_ISSUE_TRANSITION");
    }

    public List<FilterDto> findByProjectIdForIssueAssigneeChange(long projectId) {
        return this.findByProjectIdAndFlagInConnectedConversations(projectId, "TRACK_ISSUE_ASSIGNEE_CHANGE");
    }

    public List<FilterDto> findByProjectIdForCommentCreation(long projectId) {
        return this.findByProjectIdAndFlagInConnectedConversations(projectId, "TRACK_COMMENT_CREATION");
    }

    private List<FilterDto> findByProjectIdAndFlagInConnectedConversations(long projectId, String flagName) {
        String joinCondition = "filter.CONVERSATION_ID = conversation.ID";
        FilterAo[] aos = (FilterAo[])this.ao.find(FilterAo.class, Query.select().alias(FilterAo.class, "filter").alias(ConversationAo.class, "conversation").join(ConversationAo.class, joinCondition).where("filter." + flagName + " = ? AND conversation." + "PROJECT_ID" + " = ?", new Object[]{true, projectId}).order("ID ASC"));
        List<FilterDto> dtos = this.toDtoList(aos);
        return dtos;
    }

    private FilterDto create(FilterDto filter) {
        Map<String, Object> fields = filter.toMapWithAoNames();
        FilterAo createdAo = (FilterAo)this.ao.create(FilterAo.class, fields);
        Optional<FilterDto> createdDto = this.toDto(this.findAoById(createdAo.getId()));
        return createdDto.get();
    }

    private FilterDto update(FilterDto filter) {
        Long id = filter.getId();
        FilterAo persistedFilter = this.findAoById(id);
        filter.populateAo(persistedFilter);
        persistedFilter.save();
        Optional<FilterDto> updatedDto = this.findById(filter.getId());
        return updatedDto.get();
    }

    public FilterDto createOrUpdate(FilterDto filter) {
        return (FilterDto)this.ao.executeInTransaction(() -> {
            Long id = filter.getId();
            FilterDto persistedFilter = id == 0L ? this.create(filter) : this.update(filter);
            return persistedFilter;
        });
    }

    public int delete(long id) {
        return this.ao.deleteWithSQL(FilterAo.class, "ID = ?", new Object[]{id});
    }

    public int deleteByConversationId(long conversationId) {
        return this.ao.deleteWithSQL(FilterAo.class, "CONVERSATION_ID = ?", new Object[]{conversationId});
    }

    private Optional<FilterDto> toDto(FilterAo filter) {
        return Optional.ofNullable(filter).map(FilterDto::fromAo).map(dto -> {
            ConversationDto conversationDto = ConversationDto.fromAo(filter.getConversation());
            dto.setConversation(conversationDto);
            conversationDto.addFilter((FilterDto)dto);
            return dto;
        });
    }

    private List<FilterDto> toDtoList(FilterAo ... aoArray) {
        return Arrays.stream(aoArray).map(this::toDto).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

