/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugins.stride.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.plugins.stride.exception.ConversationNotFoundException;
import com.atlassian.jira.plugins.stride.exception.StaleConversationException;
import com.atlassian.jira.plugins.stride.model.TokenStatus;
import com.atlassian.jira.plugins.stride.model.ao.ConversationAo;
import com.atlassian.jira.plugins.stride.model.dto.ConversationDto;
import com.atlassian.jira.plugins.stride.model.dto.FilterDto;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import net.java.ao.Query;

@Named
public class ConversationDao {
    private final ActiveObjects ao;

    @Inject
    public ConversationDao(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public int countAll() {
        return this.ao.count(ConversationAo.class);
    }

    public int countDisconnected() {
        return this.ao.count(ConversationAo.class, Query.select().where("ACCESS_TOKEN_STATUS = ?", new Object[]{TokenStatus.DISCONNECTED}));
    }

    public int countAllByProjectId(long projectId) {
        return this.ao.count(ConversationAo.class, Query.select().where("PROJECT_ID = ?", new Object[]{projectId}));
    }

    public List<ConversationDto> findAll() {
        ConversationAo[] aos = (ConversationAo[])this.ao.find(ConversationAo.class, Query.select().order("UPDATED_AT DESC"));
        List<ConversationDto> dtos = this.toDtoList(aos);
        return dtos;
    }

    public Optional<ConversationDto> findById(long id) {
        ConversationAo conversationAo = this.findAoById(id);
        Optional<ConversationDto> conversationDto = this.toDto(conversationAo);
        return conversationDto;
    }

    private ConversationAo findAoById(long id) {
        return (ConversationAo)this.ao.get(ConversationAo.class, (Object)id);
    }

    public List<ConversationDto> findByProjectId(Long projectId) {
        ConversationAo[] aos = (ConversationAo[])this.ao.find(ConversationAo.class, Query.select().where("PROJECT_ID = ?", new Object[]{projectId}).order("UPDATED_AT DESC"));
        List<ConversationDto> dtos = this.toDtoList(aos);
        return dtos;
    }

    public List<ConversationDto> findDisconnected() {
        ConversationAo[] aos = (ConversationAo[])this.ao.find(ConversationAo.class, Query.select().where("ACCESS_TOKEN_STATUS = ?", new Object[]{TokenStatus.DISCONNECTED}).order("UPDATED_AT DESC"));
        List<ConversationDto> dtos = this.toDtoList(aos);
        return dtos;
    }

    public Set<Long> getConnectedProjectIds() {
        return Stream.of(this.ao.find(ConversationAo.class, Query.select((String)"PROJECT_ID").distinct())).map(ConversationAo::getProjectId).collect(Collectors.toSet());
    }

    public Set<Long> getConversationIdsByCriteria(String cloudId, String conversationId, long projectId) {
        String condition = String.format("%s = ? AND %s = ? AND %s = ?", "CLOUD_ID", "CONVERSATION_ID", "PROJECT_ID");
        ConversationAo[] aos = (ConversationAo[])this.ao.find(ConversationAo.class, Query.select((String)"ID").where(condition, new Object[]{cloudId, conversationId, projectId}));
        Set<Long> duplicateIds = Arrays.stream(aos).map(ConversationAo::getId).collect(Collectors.toSet());
        return duplicateIds;
    }

    private ConversationDto create(ConversationDto conversation) {
        conversation.setVersion(1L);
        conversation.setCreatedBy(conversation.getUpdatedBy());
        conversation.setCreatedAt(conversation.getUpdatedAt());
        Map<String, Object> fields = conversation.toMapWithAoNames();
        ConversationAo createdAo = (ConversationAo)this.ao.create(ConversationAo.class, fields);
        Optional<ConversationDto> createdDto = this.toDto(createdAo);
        return createdDto.get();
    }

    private ConversationDto update(ConversationDto conversation) {
        Long id = conversation.getId();
        ConversationAo persistedConversation = this.findAoById(id);
        if (persistedConversation == null) {
            throw new ConversationNotFoundException();
        }
        if (persistedConversation.getVersion() != conversation.getVersion()) {
            throw new StaleConversationException();
        }
        conversation.populateAo(persistedConversation);
        persistedConversation.setVersion(persistedConversation.getVersion() + 1L);
        persistedConversation.save();
        Optional<ConversationDto> updatedDto = this.findById(conversation.getId());
        return updatedDto.get();
    }

    public ConversationDto createOrUpdate(ConversationDto conversation) {
        return (ConversationDto)this.ao.executeInTransaction(() -> {
            Long id = conversation.getId();
            ConversationDto persistedConversation = id == 0L ? this.create(conversation) : this.update(conversation);
            return persistedConversation;
        });
    }

    public void updateStatus(long id, TokenStatus status) {
        this.ao.executeInTransaction(() -> {
            ConversationAo conversation = this.findAoById(id);
            conversation.setAccessTokenStatus(status);
            conversation.save();
            return null;
        });
    }

    public int delete(long id) {
        return this.ao.deleteWithSQL(ConversationAo.class, "ID = ?", new Object[]{id});
    }

    private Optional<ConversationDto> toDto(ConversationAo conversation) {
        return Optional.ofNullable(conversation).map(ConversationDto::fromAo).map(dto -> {
            Arrays.stream(conversation.getFilters()).map(FilterDto::fromAo).map(filter -> {
                filter.setConversation((ConversationDto)dto);
                return filter;
            }).forEachOrdered(dto::addFilter);
            return dto;
        });
    }

    private List<ConversationDto> toDtoList(ConversationAo[] aoArray) {
        return Arrays.stream(aoArray).map(this::toDto).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

