define("innovalog.create-issue", [], function () {
    AJS.$("form[name='jiraform']").submit(function (event) {
        AJS.$("textarea.codeEditor").each(function () {
            if (AJS.$(this).data("editor"))
                AJS.$(this).data("editor").save();
        });

        //build the list of fields
        var fields = {};
        AJS.$('#fieldList .field-edit').each(function () {
            var elem = AJS.$(this);
            var fieldId = elem.attr("data-fieldid");
            var action = elem.find("#action").val();
            fields[fieldId] = {action: action};
            if (action == "set" || action == "script" || action == "template")
                fields[fieldId].value = elem.find(".codeEditor").val();
            elem.find(".codeEditor").removeAttr("name");
        });

        AJS.$("input#fieldsToSet").val(JSON.stringify(fields));

        if (!AJS.$("#parentIssueGroup").is(":visible"))
            AJS.$("#parentIssueType").val("");

        if (!AJS.$("#commentIssue").prop("checked")) {
            AJS.$("#commentType").val("rawValue");
            AJS.$("#comment").val("");
        }
    });

    var projects, issuetypes;
    var currentIssueType;
    var fieldtemplate;

    projects = JSON.parse(AJS.$("#projects").html());
    issuetypes = JSON.parse(AJS.$("#issuetypes").html());
    fieldtemplate = AJS.$(AJS.$('#hidden-field-template').html());

    currentIssueType = AJS.$("#issuetype").attr("data-initialvalue");

    AJS.$(document).on('change.action-select', 'select.action-select', function () {
        var editorBlock = AJS.$(this).parent().find('.editor-block');
        if (this.value == 'copy')
            editorBlock.hide();
        else if (this.value == 'script' || this.value == 'template') {
            var textArea = editorBlock.find(".codeEditor");
            editorBlock.show();
            if (!textArea.data("editor")) {
                //initialize script editor
                var codeEditor = require('innovalog.code-editor');
                var editor = (codeEditor)();
                textArea.data("editor", editor);
                editor.init(editorBlock.parent().parent().attr("data-fieldid"), false, "", "", "", false);
                editor.wrapTextArea(textArea.get(0), this.value == 'script' ? 'groovy' : 'groovy-template');
            } else
                textArea.data("editor").wrapTextArea(textArea.get(0), this.value == 'script' ? 'groovy' : 'groovy-template')
        } else {  //this.value == 'set'
            var textArea = editorBlock.find(".codeEditor");
            if (textArea.data("editor"))
                textArea.data("editor").unwrapTextArea();
            editorBlock.show();
        }
    });

    //update the inital state
    AJS.$(".action-select").each(function () {
        AJS.$(this).trigger("change");
    });

    AJS.$(document).on('click', 'button#remove-field', removeField);

    AJS.$('input#commentIssue').click(onCommentChange);
    onCommentChange();

    AJS.$("#project").change(onProjectChange);
    AJS.$("#add-field").click(addField);
    AJS.$("#issuetype").change(onIssueTypeChange);
    AJS.$("#parentIssueType").change(onParentIssueChange);
    AJS.$("#commentType").change(onCommentTypeChange);
    onProjectChange();
    onIssueTypeChange();
    onParentIssueChange();

    AJS.$('#fields option[hidden!="hidden"]:eq(0)').prop('selected', true);

    function onIssueTypeChange() {
        var selectedIssueType = AJS.$('#issuetype').val();

        if (issuetypes.some(function (issueType) {
                return issueType.id == selectedIssueType && issueType.subtask;
            }))
            AJS.$("#parentIssueGroup").show();
        else
            AJS.$("#parentIssueGroup").hide();
    }

    function onParentIssueChange() {
        if (AJS.$("#parentIssueType").val() == 'currentIssue')
            AJS.$("#calculatedParentIssue-group").hide();
        else {
            AJS.$("#calculatedParentIssue-group").show();
            if (AJS.$("#parentIssueType").val() == 'calculated')
                AJS.$("#calculatedParentIssue").data("editor").wrapTextArea("#calculatedParentIssue", 'groovy');
            else
                AJS.$("#calculatedParentIssue").data("editor").unwrapTextArea();
        }
    }

    function onCommentChange() {
        if (AJS.$("#commentIssue").prop("checked"))
            AJS.$('#commentGroup').show();
        else
            AJS.$('#commentGroup').hide();
    }

    function onProjectChange() {
        var currentProject = AJS.$("#project").val();
        if (currentProject == '$calculated$') {
            AJS.$("#calculatedProjectKey-group").show();
            AJS.$("#calculatedProjectKey").data("editor").wrapTextArea(AJS.$("#calculatedProjectKey"), "groovy");
            AJS.$("#calculatedProjectKey").attr("data-aui-validation-required", '');
        } else {
            AJS.$("#calculatedProjectKey-group").hide();
            AJS.$("#calculatedProjectKey").data("editor").unwrapTextArea();
            AJS.$("#calculatedProjectKey").removeAttr("data-aui-validation-required");
        }

        //fill the issuetype select
        var issuetypeSelect = AJS.$("#issuetype");
        currentIssueType = issuetypeSelect.val() || currentIssueType;
        issuetypeSelect.empty();
        if (currentProject != '$calculated$' && currentProject != '$sameAsCurrentIssue$') {
            //we have a real project
            var projectObject;
            if (projects.some(function (project) {
                    if (project.key == currentProject) {
                        projectObject = project;
                        return true;
                    }
                })) {
                projectObject.issueTypes.forEach(function (issuetype) {
                    issuetypeSelect.append("<option value='" + issuetype.id + "'>" + issuetype.name + "</option>");
                });
            }
        } else {
            issuetypes.forEach(function (issuetype) {
                issuetypeSelect.append("<option value='" + issuetype.id + "'>" + issuetype.name + "</option>");
            });
        }
        issuetypeSelect.val(currentIssueType);
    }

    function addField() {
        var item = fieldtemplate.clone();
        var field = AJS.$("#fields option:selected");
        item.find("#fieldName").text(field.text() + ":");
        var fieldId = field.attr('value');
        item.attr("data-fieldid", fieldId);
        item.find(".editor-block").parent().attr("id", fieldId + "-group");
        item.find(".editor-block").hide();
        item.find("section.aui-dialog2").attr("id", "test-dialog-" + fieldId);
        item.find("button.script-tester").attr("data-dialog-id", "test-dialog-" + fieldId);
        AJS.$('#fieldList').append(item);

        //also remove the field from the combo box
        field.attr('hidden', true);
        AJS.$('#fields option[hidden!="hidden"]:eq(0)').prop('selected', true);
    }

    function removeField() {
        var parent = AJS.$(this).parent();
        var fieldId = parent.attr('data-fieldid');
        var opt = AJS.$('#fields option[value="' + fieldId + '"]');
        opt.removeAttr('hidden').prop('selected', true);
        parent.remove();
        AJS.$("section.aui-dialog2#test-dialog-" + fieldId).remove();
    }

    function onCommentTypeChange() {
        if (AJS.$("#comment").data("editor"))
            if (AJS.$("#commentType").val() == 'expression') {
                AJS.$("#comment").data("editor").wrapTextArea("#comment", 'groovy');
            } else if (AJS.$("#commentType").val() == 'template') {
                AJS.$("#comment").data("editor").wrapTextArea("#comment", 'groovy-template');
            }
            else {
                AJS.$("#comment").data("editor").unwrapTextArea();
            }
    }
});
