/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.workflow.utils;

import com.atlassian.core.util.InvalidDurationException;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.ModifiedValue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.converters.DatePickerConverter;
import com.atlassian.jira.issue.customfields.impl.AbstractMultiCFType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.ProjectCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.customfields.manager.OptionsManager;
import com.atlassian.jira.issue.customfields.option.Option;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.issue.util.IssueChangeHolder;
import com.atlassian.jira.issue.vote.VoteManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.issue.worklog.WorkRatio;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.JiraDurationUtils;
import com.google.common.base.Throwables;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.innovalog.workflow.utils.FieldValueHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldValueService {
    private final Logger log = LoggerFactory.getLogger(FieldValueService.class);
    private final FieldManager fieldManager;
    private final IssueLinkManager issueLinkManager;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private final WatcherManager watcherManager;
    private final JiraAuthenticationContext authenticationContext;
    private final CommentManager commentManager;
    private final CustomFieldManager customFieldManager;
    private final OptionsManager optionsManager;
    private final UserManager userManager;
    private final VersionManager versionManager;
    private final ProjectComponentManager projectComponentManager;
    private final ConstantsManager constantsManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final DateFieldFormat dateFieldFormat;
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final LabelManager labelManager;
    private final ProjectManager projectManager;
    private final GroupManager groupManager;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final WorklogManager worklogManager;
    private final DatePickerConverter dateConverter;
    private final DateTimeFormatter dateTimeConverter;
    private final BuildUtilsInfo buildUtilsInfo;
    private final JiraDurationUtils jiraDurationUtils;
    private final ApplicationProperties applicationProperties;
    private final VoteManager voteManager;
    private final DateTimeFormatter datePickerFormatter;

    public FieldValueService(DateTimeFormatterFactory dateTimeFormatterFactory, FieldManager fieldManager, ProjectComponentManager projectComponentManager, VersionManager versionManager, IssueLinkManager issueLinkManager, UserManager userManager, OptionsManager optionsManager, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory, WatcherManager watcherManager, JiraAuthenticationContext authenticationContext, CommentManager commentManager, CustomFieldManager customFieldManager, ConstantsManager constantsManager, IssueSecurityLevelManager issueSecurityLevelManager, IssueSecuritySchemeManager issueSecuritySchemeManager, DateFieldFormat dateFieldFormat, FieldCollectionsUtils fieldCollectionsUtils, LabelManager labelManager, ProjectManager projectManager, GroupManager groupManager, UserIssueHistoryManager userIssueHistoryManager, WorklogManager worklogManager, DatePickerConverter dateConverter, BuildUtilsInfo buildUtilsInfo, ApplicationProperties applicationProperties, VoteManager voteManager) {
        this.fieldManager = fieldManager;
        this.issueLinkManager = issueLinkManager;
        this.aggregateTimeTrackingCalculatorFactory = aggregateTimeTrackingCalculatorFactory;
        this.watcherManager = watcherManager;
        this.authenticationContext = authenticationContext;
        this.commentManager = commentManager;
        this.datePickerFormatter = dateTimeFormatterFactory.formatter().forLoggedInUser().withStyle(DateTimeStyle.DATE_TIME_PICKER);
        this.customFieldManager = customFieldManager;
        this.optionsManager = optionsManager;
        this.userManager = userManager;
        this.versionManager = versionManager;
        this.projectComponentManager = projectComponentManager;
        this.constantsManager = constantsManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.dateFieldFormat = dateFieldFormat;
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.labelManager = labelManager;
        this.projectManager = projectManager;
        this.groupManager = groupManager;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.worklogManager = worklogManager;
        this.dateConverter = dateConverter;
        this.dateTimeConverter = dateTimeFormatterFactory.formatter().withDefaultZone().withStyle(DateTimeStyle.DATE_TIME_PICKER);
        this.buildUtilsInfo = buildUtilsInfo;
        this.voteManager = voteManager;
        this.jiraDurationUtils = (JiraDurationUtils)ComponentAccessor.getComponent(JiraDurationUtils.class);
        this.applicationProperties = applicationProperties;
    }

    public FieldValueHolder createFieldValueHolder(Issue issue, String fieldId) {
        return this.createFieldValueHolder(issue, fieldId, null);
    }

    public FieldValueHolder createFieldValueHolder(String fieldId, Object value) {
        return this.createFieldValueHolder(null, fieldId, value);
    }

    private FieldValueHolder createFieldValueHolder(Issue issue, String fieldId, Object fieldValue) {
        Field field = this.fieldManager.getField(fieldId);
        Object value = issue != null ? this.getFieldValueFromIssue(issue, field, false) : fieldValue;
        CustomFieldType customFieldType = null;
        if (field instanceof CustomField) {
            customFieldType = ((CustomField)field).getCustomFieldType();
        }
        if (value == null) {
            return new FieldValueHolder();
        }
        if (value instanceof GenericValue) {
            return new FieldValueHolder(((GenericValue)value).get("key"));
        }
        if (value instanceof Map) {
            if (customFieldType instanceof CascadingSelectCFType) {
                ArrayList<Object> val = new ArrayList<Object>(2);
                if (!((Map)value).containsKey(null)) {
                    return new FieldValueHolder();
                }
                val.add(this.convertToScalar(((Map)value).get(null), field));
                if (((Map)value).containsKey("1")) {
                    val.add(this.convertToScalar(((Map)value).get("1"), field));
                }
                return new FieldValueHolder(val);
            }
            throw new IllegalStateException("Field type " + customFieldType + " of field " + field.getName() + " is not supported.");
        }
        try {
            if (value instanceof Collection) {
                ArrayList<Object> val = new ArrayList<Object>();
                for (Object o : (Collection)value) {
                    val.add(this.convertToScalar(o, field));
                }
                return new FieldValueHolder(val);
            }
            return new FieldValueHolder(this.convertToScalar(value, field));
        }
        catch (Exception e) {
            throw new IllegalStateException("Field type " + customFieldType + " of field " + field.getName() + " is not supported.", e);
        }
    }

    public void addValueToIssueInputParameters(IssueInputParameters issueInputParameters, String fieldId, FieldValueHolder fieldValueHolder, IssueContext issueContext) {
        if (fieldValueHolder.isEmpty()) {
            issueInputParameters.addCustomFieldValue(fieldId, null);
            return;
        }
        Object firstVal = fieldValueHolder.getFirstValueOrNull();
        if (this.fieldManager.isCustomField(fieldId)) {
            CustomField cf = this.customFieldManager.getCustomFieldObject(fieldId);
            CustomFieldType customFieldType = cf.getCustomFieldType();
            if (customFieldType instanceof CascadingSelectCFType) {
                List<Object> values = fieldValueHolder.getMultiValues(" - ");
                Option option = this.convertToOption(issueContext, cf, values.get(0));
                if (option.getParentOption() != null) {
                    issueInputParameters.addCustomFieldValue(fieldId, new String[]{option.getParentOption().getOptionId().toString()});
                    issueInputParameters.addCustomFieldValue(fieldId + ":1", new String[]{option.getOptionId().toString()});
                } else {
                    issueInputParameters.addCustomFieldValue(fieldId, new String[]{option.getOptionId().toString()});
                    if (values.size() > 1) {
                        Option childOption = this.convertToChildOption(issueContext, cf, option, values.get(1));
                        issueInputParameters.addCustomFieldValue(fieldId + ":1", new String[]{childOption.getOptionId().toString()});
                    }
                }
            } else if (customFieldType instanceof DateCFType) {
                issueInputParameters.addCustomFieldValue(fieldId, new String[]{customFieldType.getStringFromSingularObject((Object)this.toDate(firstVal))});
            } else if (customFieldType instanceof DateTimeCFType) {
                issueInputParameters.addCustomFieldValue(fieldId, new String[]{customFieldType.getStringFromSingularObject((Object)this.toDateTime(firstVal))});
            } else if (customFieldType instanceof LabelsCFType) {
                List<String> vals = fieldValueHolder.getMultiStringValues(" |,");
                issueInputParameters.addCustomFieldValue(fieldId, vals.toArray(new String[0]));
            } else if (customFieldType instanceof AbstractMultiCFType) {
                List<Object> values = fieldValueHolder.getMultiValues(",");
                String[] stringValues = new String[values.size()];
                int pos = 0;
                for (Object value : values) {
                    if (customFieldType instanceof MultiSelectCFType) {
                        value = this.convertToOption(issueContext, cf, value).getOptionId().toString();
                    } else if (customFieldType instanceof MultiUserCFType) {
                        value = this.convertToAppUser(value).getUsername();
                    } else if (customFieldType instanceof MultiGroupCFType) {
                        value = this.convertToGroup(value).getName();
                        if (!((MultiGroupCFType)customFieldType).isMultiple()) {
                            stringValues[pos++] = (String)value;
                            break;
                        }
                    } else if (customFieldType instanceof VersionCFType) {
                        value = this.convertToVersion(issueContext, value).getId().toString();
                        if (!((VersionCFType)customFieldType).isMultiple()) {
                            stringValues[pos++] = (String)value;
                            break;
                        }
                    }
                    stringValues[pos++] = (String)value;
                }
                issueInputParameters.addCustomFieldValue(fieldId, stringValues);
            } else if (customFieldType instanceof NumberCFType) {
                issueInputParameters.addCustomFieldValue(fieldId, new String[]{customFieldType.getStringFromSingularObject((Object)this.toDouble(firstVal))});
            } else if (customFieldType instanceof SelectCFType) {
                issueInputParameters.addCustomFieldValue(fieldId, new String[]{customFieldType.getStringFromSingularObject((Object)this.convertToOption(issueContext, cf, firstVal))});
            } else if (customFieldType instanceof ProjectCFType) {
                Project project = this.convertToProject(firstVal);
                String projectString = project != null && this.buildUtilsInfo.getVersionNumbers()[0] < 7 ? customFieldType.getStringFromSingularObject((Object)project.getGenericValue()) : customFieldType.getStringFromSingularObject((Object)project);
                issueInputParameters.addCustomFieldValue(fieldId, new String[]{projectString});
            } else if (customFieldType instanceof UserCFType) {
                issueInputParameters.addCustomFieldValue(fieldId, new String[]{customFieldType.getStringFromSingularObject((Object)this.convertToAppUser(firstVal))});
            } else {
                issueInputParameters.addCustomFieldValue(fieldId, fieldValueHolder.getMultiStringValues(",").toArray(new String[0]));
            }
        } else {
            if (fieldId.equals("attachment")) {
                throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
            }
            if (fieldId.equals("versions")) {
                this.setMultiFieldValue(issueInputParameters, fieldValueHolder, Version.class, issueContext, fieldId);
            } else {
                if (fieldId.equals("comment")) {
                    throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                }
                if (fieldId.equals("components")) {
                    this.setMultiFieldValue(issueInputParameters, fieldValueHolder, ProjectComponent.class, issueContext, fieldId);
                } else if (fieldId.equals("fixVersions")) {
                    this.setMultiFieldValue(issueInputParameters, fieldValueHolder, Version.class, issueContext, fieldId);
                } else {
                    if (fieldId.equals("thumbnail")) {
                        throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                    }
                    if (fieldId.equals("issuetype")) {
                        issueInputParameters.setIssueTypeId(this.convertToIssueConstant("IssueType", firstVal).getId());
                    } else {
                        if (fieldId.equals("timetracking")) {
                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                        }
                        if (fieldId.equals("issuelinks")) {
                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                        }
                        if (fieldId.equals("workratio")) {
                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                        }
                        if (fieldId.equals("issuekey")) {
                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                        }
                        if (fieldId.equals("subtasks")) {
                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                        }
                        if (fieldId.equals("priority")) {
                            issueInputParameters.setPriorityId(this.convertToIssueConstant("Priority", firstVal).getId());
                        } else if (fieldId.equals("resolution")) {
                            issueInputParameters.setResolutionId(this.convertToIssueConstant("Resolution", firstVal).getId());
                        } else if (fieldId.equals("status")) {
                            issueInputParameters.setStatusId(this.convertToIssueConstant("Status", firstVal).getId());
                        } else {
                            if (fieldId.equals("project")) {
                                throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                            }
                            if (fieldId.equals("security")) {
                                issueInputParameters.setSecurityLevelId(this.convertToSecurityLevel(firstVal, issueContext).getId());
                            } else if (fieldId.equals("timeestimate")) {
                                issueInputParameters.setRemainingEstimate(this.toDuration(firstVal));
                            } else if (fieldId.equals("timeoriginalestimate")) {
                                issueInputParameters.setOriginalEstimate(this.toDuration(firstVal));
                            } else if (fieldId.equals("timespent")) {
                                issueInputParameters.setTimeSpent(this.toDuration(firstVal));
                            } else {
                                if (fieldId.equals("aggregatetimespent")) {
                                    throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                }
                                if (fieldId.equals("aggregatetimeestimate")) {
                                    throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                }
                                if (fieldId.equals("aggregatetimeoriginalestimate")) {
                                    throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                }
                                if (fieldId.equals("assignee")) {
                                    issueInputParameters.setAssigneeId(this.convertToAppUser(firstVal).getUsername());
                                } else {
                                    if (fieldId.equals("creator")) {
                                        throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                    }
                                    if (fieldId.equals("reporter")) {
                                        issueInputParameters.setReporterId(this.convertToAppUser(firstVal).getUsername());
                                    } else if (fieldId.equals("description")) {
                                        issueInputParameters.setDescription(fieldValueHolder.getSingleStringValue("\n"));
                                    } else if (fieldId.equals("environment")) {
                                        issueInputParameters.setEnvironment(fieldValueHolder.getSingleStringValue("\n"));
                                    } else if (fieldId.equals("summary")) {
                                        issueInputParameters.setSummary(FieldValueHolder.toCFString(firstVal));
                                    } else if (fieldId.equals("duedate")) {
                                        issueInputParameters.setDueDate(this.dateFieldFormat.formatDatePicker((Date)this.toDate(firstVal)));
                                    } else {
                                        if (fieldId.equals("updated")) {
                                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                        }
                                        if (fieldId.equals("created")) {
                                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                        }
                                        if (fieldId.equals("resolutiondate")) {
                                            issueInputParameters.setResolutionDate(this.dateFieldFormat.formatDatePicker((Date)this.toDate(firstVal)));
                                        } else if (fieldId.equals("labels")) {
                                            List<String> vals = fieldValueHolder.getMultiStringValues(" |,");
                                            issueInputParameters.addCustomFieldValue(fieldId, vals.toArray(new String[0]));
                                        } else {
                                            if (fieldId.equals("watches")) {
                                                throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                            }
                                            if (fieldId.equals("votes")) {
                                                throw new IllegalArgumentException("Issue field \"" + fieldId + "\" cannot be set.");
                                            }
                                            throw new IllegalArgumentException("Issue field \"" + fieldId + "\" is not supported.");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public Object getFieldValueFromIssue(Issue issue, Field field, boolean compatibleWith4x) {
        Object retVal;
        block63: {
            retVal = null;
            try {
                if (this.fieldManager.isCustomField(field)) {
                    CustomField customField = (CustomField)field;
                    retVal = issue.getCustomFieldValue(customField);
                    if (compatibleWith4x && retVal instanceof Option) {
                        retVal = ((Option)retVal).getValue();
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("Got field value [object=%s;class=%s]", retVal, retVal != null ? retVal.getClass() : ""));
                    }
                    break block63;
                }
                String fieldId = field.getId();
                Object retCollection = null;
                if (fieldId.equals("attachment")) {
                    retVal = issue.getAttachments();
                    if (compatibleWith4x && retVal != null && ((Collection)retVal).isEmpty()) {
                        retVal = null;
                    }
                    break block63;
                }
                if (fieldId.equals("versions")) {
                    retVal = issue.getAffectedVersions();
                    if (compatibleWith4x && retVal != null && ((Collection)retVal).isEmpty()) {
                        retVal = null;
                    }
                    break block63;
                }
                if (fieldId.equals("comment")) {
                    retVal = this.commentManager.getComments(issue);
                    break block63;
                }
                if (fieldId.equals("components")) {
                    retVal = issue.getComponentObjects();
                    if (compatibleWith4x && retVal != null && ((Collection)retVal).isEmpty()) {
                        retVal = null;
                    }
                    break block63;
                }
                if (fieldId.equals("fixVersions")) {
                    retVal = issue.getFixVersions();
                    if (compatibleWith4x && retVal != null && ((Collection)retVal).isEmpty()) {
                        retVal = null;
                    }
                    break block63;
                }
                if (fieldId.equals("thumbnail")) {
                    this.log.warn("FieldValueService does not support the 'thumbnail' field");
                    break block63;
                }
                if (fieldId.equals("issuetype")) {
                    retVal = issue.getIssueTypeObject();
                    break block63;
                }
                if (fieldId.equals("timetracking")) {
                    this.log.warn("FieldValueService does not support the 'timetracking' field");
                    break block63;
                }
                if (fieldId.equals("issuelinks")) {
                    retVal = new ArrayList(this.issueLinkManager.getOutwardLinks(issue.getId()));
                    ((Collection)retVal).addAll(this.issueLinkManager.getInwardLinks(issue.getId()));
                    break block63;
                }
                if (fieldId.equals("workratio")) {
                    retVal = WorkRatio.getWorkRatio((Issue)issue);
                    break block63;
                }
                if (fieldId.equals("issuekey")) {
                    retVal = issue.getKey();
                    break block63;
                }
                if (fieldId.equals("subtasks")) {
                    retVal = issue.getSubTaskObjects();
                    if (compatibleWith4x && retVal != null && ((Collection)retVal).isEmpty()) {
                        retVal = null;
                    }
                    break block63;
                }
                if (fieldId.equals("priority")) {
                    retVal = issue.getPriorityObject();
                    break block63;
                }
                if (fieldId.equals("resolution")) {
                    retVal = issue.getResolutionObject();
                    break block63;
                }
                if (fieldId.equals("status")) {
                    retVal = issue.getStatusObject();
                    break block63;
                }
                if (fieldId.equals("project")) {
                    retVal = issue.getProjectObject();
                    break block63;
                }
                if (fieldId.equals("security")) {
                    Long securityLevelId = issue.getSecurityLevelId();
                    if (securityLevelId != null) {
                        retVal = this.issueSecurityLevelManager.getSecurityLevel(securityLevelId.longValue());
                    }
                    break block63;
                }
                if (fieldId.equals("timeestimate")) {
                    retVal = issue.getEstimate();
                    break block63;
                }
                if (fieldId.equals("timeoriginalestimate")) {
                    retVal = issue.getOriginalEstimate();
                    break block63;
                }
                if (fieldId.equals("timespent")) {
                    retVal = issue.getTimeSpent();
                    break block63;
                }
                if (fieldId.equals("aggregatetimespent")) {
                    retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getTimeSpent();
                    break block63;
                }
                if (fieldId.equals("aggregatetimeestimate")) {
                    retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getRemainingEstimate();
                    break block63;
                }
                if (fieldId.equals("aggregatetimeoriginalestimate")) {
                    retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getOriginalEstimate();
                    break block63;
                }
                if (fieldId.equals("aggregateprogress")) {
                    long estimate = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getOriginalEstimate();
                    if (estimate != 0L) {
                        retVal = this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue).getTimeSpent() / estimate;
                    }
                    break block63;
                }
                if (fieldId.equals("assignee")) {
                    retVal = issue.getClass().getMethod("getAssigneeUser", new Class[0]).invoke((Object)issue, new Object[0]);
                    break block63;
                }
                if (fieldId.equals("creator")) {
                    retVal = issue.getClass().getMethod("getCreator", new Class[0]).invoke((Object)issue, new Object[0]);
                    break block63;
                }
                if (fieldId.equals("reporter")) {
                    retVal = issue.getClass().getMethod("getReporterUser", new Class[0]).invoke((Object)issue, new Object[0]);
                    break block63;
                }
                if (fieldId.equals("description")) {
                    retVal = issue.getDescription();
                    break block63;
                }
                if (fieldId.equals("environment")) {
                    retVal = issue.getEnvironment();
                    break block63;
                }
                if (fieldId.equals("summary")) {
                    retVal = issue.getSummary();
                    break block63;
                }
                if (fieldId.equals("duedate")) {
                    retVal = issue.getDueDate();
                    break block63;
                }
                if (fieldId.equals("updated")) {
                    retVal = issue.getUpdated();
                    break block63;
                }
                if (fieldId.equals("created")) {
                    retVal = issue.getCreated();
                    break block63;
                }
                if (fieldId.equals("resolutiondate")) {
                    retVal = issue.getResolutionDate();
                    break block63;
                }
                if (fieldId.equals("lastViewed")) {
                    List fullHistory = this.userIssueHistoryManager.getFullIssueHistoryWithoutPermissionChecks(this.authenticationContext.getUser());
                    for (UserHistoryItem historyItem : fullHistory) {
                        if (!issue.getId().toString().equals(historyItem.getEntityId())) continue;
                        retVal = new Timestamp(historyItem.getLastViewed());
                        break block63;
                    }
                    break block63;
                }
                if (fieldId.equals("progress")) {
                    if (issue.getOriginalEstimate() != 0L) {
                        retVal = issue.getTimeSpent() / issue.getOriginalEstimate();
                    }
                } else if (fieldId.equals("worklog")) {
                    retVal = this.worklogManager.getByIssue(issue);
                } else if (fieldId.equals("labels")) {
                    retVal = issue.getLabels();
                } else if (fieldId.equals("watches")) {
                    retVal = this.watcherManager.getWatchers(issue, this.authenticationContext.getLocale());
                } else if (fieldId.equals("votes")) {
                    retVal = this.voteManager.getVotersFor(issue, this.authenticationContext.getLocale());
                } else {
                    this.log.warn("Issue field \"" + fieldId + "\" is not supported.");
                    GenericValue gvIssue = issue.getGenericValue();
                    if (gvIssue != null) {
                        retVal = gvIssue.get(fieldId);
                    }
                }
            }
            catch (NullPointerException e) {
                retVal = null;
                this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                retVal = null;
                this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                retVal = null;
                this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                retVal = null;
                this.log.error("Unable to get field \"" + field.getId() + "\" value", (Throwable)e);
            }
        }
        return retVal;
    }

    public FieldValueHolder createFieldValueHolderFomGroovyResult(Object res, String fieldId) {
        if (res instanceof String[]) {
            return new FieldValueHolder(Arrays.asList(res));
        }
        return this.createFieldValueHolder(null, fieldId, res);
    }

    public void setFieldValue(MutableIssue issue, Field field, FieldValueHolder fieldValueHolder, Object mergeWith, IssueChangeHolder changeHolder, boolean updateValue) {
        boolean bMerged;
        boolean bl = bMerged = mergeWith == null;
        if (this.fieldManager.isCustomField(field)) {
            CustomField cf;
            CustomField customField = cf = (CustomField)field;
            Object oldValue = issue.getCustomFieldValue(customField);
            CustomFieldType cfType = customField.getCustomFieldType();
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("Set custom field value [field=%s,type=%s,oldValue=%s,newValue=%s]", customField, cfType, oldValue, fieldValueHolder.toString()));
            }
            CustomFieldType customFieldType = cf.getCustomFieldType();
            Object newValue = null;
            Object firstVal = fieldValueHolder.getFirstValueOrNull();
            if (customFieldType instanceof CascadingSelectCFType) {
                if (!fieldValueHolder.isEmpty()) {
                    newValue = new HashMap();
                    List<Object> values = fieldValueHolder.getMultiValues(" - ");
                    Option option = this.convertToOption((IssueContext)issue, cf, values.get(0));
                    if (option.getParentOption() != null) {
                        ((Map)newValue).put(CascadingSelectCFType.PARENT_KEY, option.getParentOption());
                        ((Map)newValue).put("1", option);
                    } else {
                        ((Map)newValue).put(CascadingSelectCFType.PARENT_KEY, option);
                        if (values.size() > 1) {
                            Option childOption = this.convertToChildOption((IssueContext)issue, cf, option, values.get(1));
                            ((Map)newValue).put("1", childOption);
                        }
                    }
                }
            } else if (customFieldType instanceof DateCFType) {
                newValue = this.toDate(firstVal);
            } else if (customFieldType instanceof DateTimeCFType) {
                newValue = this.toDateTime(firstVal);
            } else if (customFieldType instanceof LabelsCFType) {
                List<String> values = fieldValueHolder.getMultiStringValues(" |,");
                newValue = mergeWith != null ? new HashSet((Collection)mergeWith) : new HashSet();
                for (String label : values) {
                    ((Set)newValue).addAll(LabelParser.buildFromString((String)label));
                }
                bMerged = true;
            } else if (customFieldType instanceof AbstractMultiCFType) {
                List<Object> values = fieldValueHolder.getMultiValues(",");
                if (!(customFieldType instanceof MultiGroupCFType && !((MultiGroupCFType)customFieldType).isMultiple() || customFieldType instanceof VersionCFType && ((VersionCFType)customFieldType).isMultiple())) {
                    bMerged = true;
                }
                newValue = new HashSet();
                for (Object value : values) {
                    if (customFieldType instanceof MultiSelectCFType) {
                        ((Set)newValue).add(this.convertToOption((IssueContext)issue, cf, value));
                        continue;
                    }
                    if (customFieldType instanceof MultiUserCFType) {
                        ((Set)newValue).add(this.convertToAppUser(value));
                        continue;
                    }
                    if (customFieldType instanceof MultiGroupCFType) {
                        ((Set)newValue).add(this.convertToGroup(value));
                        if (((MultiGroupCFType)customFieldType).isMultiple()) continue;
                        break;
                    }
                    if (customFieldType instanceof VersionCFType) {
                        ((Set)newValue).add(this.convertToVersion((IssueContext)issue, value));
                        if (((VersionCFType)customFieldType).isMultiple()) continue;
                        break;
                    }
                    ((Set)newValue).add(cfType.getSingularObjectFromString(value.toString()));
                }
                if (mergeWith != null && bMerged) {
                    ((Set)newValue).addAll((Collection)mergeWith);
                }
            } else if (customFieldType instanceof NumberCFType) {
                newValue = this.toDouble(firstVal);
            } else if (customFieldType instanceof SelectCFType) {
                newValue = this.convertToOption((IssueContext)issue, cf, firstVal);
            } else if (customFieldType instanceof ProjectCFType) {
                Project project = this.convertToProject(firstVal);
                if (project != null) {
                    newValue = customFieldType.getSingularObjectFromString(project.getId().toString());
                }
            } else if (customFieldType instanceof UserCFType) {
                newValue = this.convertToAppUser(firstVal);
            } else {
                CustomFieldParamsImpl fieldParams = new CustomFieldParamsImpl(customField, (Object)fieldValueHolder.getSingleStringValue(","));
                newValue = cfType.getValueFromCustomFieldParams((CustomFieldParams)fieldParams);
            }
            issue.setCustomFieldValue(customField, newValue);
            if (updateValue) {
                FieldLayoutItem fieldLayoutItem = this.fieldCollectionsUtils.getFieldLayoutItem((Issue)issue, field);
                customField.updateValue(fieldLayoutItem, (Issue)issue, new ModifiedValue(oldValue, newValue), changeHolder);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Issue [" + issue + "] got modfied fields - [" + issue.getModifiedFields() + "]");
            }
        } else {
            String fieldId = field.getId();
            Object firstVal = fieldValueHolder.getFirstValueOrNull();
            if (fieldId.equals("attachment")) {
                throw new UnsupportedOperationException("Not implemented");
            }
            if (fieldId.equals("versions")) {
                Set versions = this.getMultiFieldValue(fieldValueHolder, Version.class, (IssueContext)issue);
                if (mergeWith != null) {
                    versions.addAll((Collection)mergeWith);
                }
                bMerged = true;
                issue.setAffectedVersions(versions);
            } else {
                if (fieldId.equals("comment")) {
                    throw new UnsupportedOperationException("Not implemented");
                }
                if (fieldId.equals("components")) {
                    Set<ProjectComponent> components = this.getMultiFieldValue(fieldValueHolder, ProjectComponent.class, (IssueContext)issue);
                    if (mergeWith != null) {
                        components.addAll((Collection)mergeWith);
                    }
                    bMerged = true;
                    this.setIssueComponents(issue, components);
                } else if (fieldId.equals("fixVersions")) {
                    Set versions = this.getMultiFieldValue(fieldValueHolder, Version.class, (IssueContext)issue);
                    if (mergeWith != null) {
                        versions.addAll((Collection)mergeWith);
                    }
                    bMerged = true;
                    issue.setFixVersions(versions);
                } else {
                    if (fieldId.equals("thumbnail")) {
                        throw new UnsupportedOperationException("Not implemented");
                    }
                    if (fieldId.equals("issuetype")) {
                        issue.setIssueTypeId(this.convertToIssueConstant("IssueType", firstVal).getId());
                    } else {
                        if (fieldId.equals("timetracking")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("issuelinks")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("workratio")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("issuekey")) {
                            throw new UnsupportedOperationException("Cannot change Issue Key");
                        }
                        if (fieldId.equals("subtasks")) {
                            throw new UnsupportedOperationException("Not implemented");
                        }
                        if (fieldId.equals("priority")) {
                            issue.setPriorityId(this.convertToIssueConstant("Priority", firstVal).getId());
                        } else if (fieldId.equals("resolution")) {
                            issue.setResolutionId(this.convertToIssueConstant("Resolution", firstVal).getId());
                        } else if (fieldId.equals("status")) {
                            issue.setStatusId(this.convertToIssueConstant("Status", firstVal).getId());
                        } else if (fieldId.equals("security")) {
                            if (firstVal == null) {
                                issue.setSecurityLevelId(null);
                            } else {
                                issue.setSecurityLevelId(this.convertToSecurityLevel(firstVal, (IssueContext)issue).getId());
                            }
                        } else if (fieldId.equals("assignee")) {
                            ApplicationUser user = this.convertToAppUser(firstVal);
                            issue.setAssigneeId(user == null ? null : user.getKey());
                        } else if (fieldId.equals("duedate")) {
                            if (firstVal == null) {
                                issue.setDueDate(null);
                            } else {
                                issue.setDueDate(this.toDate(firstVal));
                            }
                        } else if (fieldId.equals("reporter")) {
                            ApplicationUser user = this.convertToAppUser(firstVal);
                            issue.setReporterId(user == null ? null : user.getKey());
                        } else if (fieldId.equals("summary")) {
                            issue.setSummary(FieldValueHolder.toCFString(firstVal));
                        } else if (fieldId.equals("description")) {
                            if (mergeWith instanceof String) {
                                issue.setDescription(mergeWith + "\n" + fieldValueHolder.getSingleStringValue("\n"));
                            } else {
                                issue.setDescription(fieldValueHolder.getSingleStringValue("\n"));
                            }
                            bMerged = true;
                        } else if (fieldId.equals("watches")) {
                            List<String> values = fieldValueHolder.getMultiStringValues(",");
                            if (mergeWith == null) {
                                for (ApplicationUser u : this.watcherManager.getWatchers((Issue)issue, this.authenticationContext.getLocale())) {
                                    this.stopWatching(issue, u);
                                }
                            }
                            for (String v : values) {
                                ApplicationUser u = this.convertToAppUser(v);
                                if (u == null || this.watcherManager.isWatching(u, (Issue)issue)) continue;
                                this.startWatching(issue, u);
                            }
                            bMerged = true;
                        } else if (fieldId.equals("votes")) {
                            List<String> values = fieldValueHolder.getMultiStringValues(",");
                            if (mergeWith == null) {
                                for (ApplicationUser u : this.voteManager.getVotersFor((Issue)issue, this.authenticationContext.getLocale())) {
                                    this.voteManager.removeVote(u, (Issue)issue);
                                }
                            }
                            for (String v : values) {
                                ApplicationUser u = this.convertToAppUser(v);
                                if (u == null || this.voteManager.hasVoted(u, (Issue)issue)) continue;
                                this.voteManager.addVote(u, (Issue)issue);
                            }
                            bMerged = true;
                        } else if (fieldId.equals("labels")) {
                            if (fieldValueHolder.isEmpty()) {
                                issue.setLabels(Collections.EMPTY_SET);
                            } else {
                                List<String> values = fieldValueHolder.getMultiStringValues(" |,");
                                HashSet newValue = mergeWith != null ? new HashSet((Collection)mergeWith) : new HashSet();
                                for (String label : values) {
                                    newValue.addAll(LabelParser.buildFromString((String)label));
                                }
                                issue.setLabels(newValue);
                            }
                            bMerged = true;
                        } else if (fieldId.equals("timespent")) {
                            if (fieldValueHolder.isEmpty()) {
                                issue.setTimeSpent(null);
                            } else {
                                issue.setTimeSpent(this.toDuration(firstVal));
                            }
                        } else if (fieldId.equals("timeestimate")) {
                            if (fieldValueHolder.isEmpty()) {
                                issue.setEstimate(null);
                            } else {
                                issue.setEstimate(this.toDuration(firstVal));
                            }
                        } else if (fieldId.equals("timeoriginalestimate")) {
                            if (fieldValueHolder.isEmpty()) {
                                issue.setOriginalEstimate(null);
                            } else {
                                issue.setOriginalEstimate(this.toDuration(firstVal));
                            }
                        } else if (fieldId.equals("environment")) {
                            if (mergeWith instanceof String) {
                                issue.setEnvironment(mergeWith + "\n" + FieldValueHolder.toCFString(firstVal));
                            } else {
                                issue.setEnvironment(FieldValueHolder.toCFString(firstVal));
                            }
                        } else {
                            throw new UnsupportedOperationException("Issue field \"" + fieldId + "\" is not supported for setting.");
                        }
                    }
                }
            }
        }
        if (!bMerged) {
            throw new UnsupportedOperationException(String.format("Field '%s' is not multi-valued", field.getName()));
        }
    }

    private Project convertToProject(Object value) {
        Project project2;
        if (value == null) {
            return null;
        }
        try {
            project2 = this.projectManager.getProjectObj(Long.valueOf(this.toDouble(value).longValue()));
            if (project2 != null) {
                return project2;
            }
        }
        catch (NumberFormatException project2) {
            // empty catch block
        }
        project2 = this.projectManager.getProjectObjByKey(FieldValueHolder.toCFString(value).trim());
        if (project2 != null) {
            return project2;
        }
        project2 = this.projectManager.getProjectObjByName(FieldValueHolder.toCFString(value).trim());
        if (project2 != null) {
            return project2;
        }
        throw new IllegalArgumentException("Project '" + FieldValueHolder.toCFString(value).trim() + "' does not exsit.");
    }

    private Group convertToGroup(Object value) {
        if (value == null) {
            return null;
        }
        return this.groupManager.getGroup(FieldValueHolder.toCFString(value).trim());
    }

    private Object convertToScalar(Object o, Field field) {
        if (o instanceof Option) {
            return ((Option)o).getValue();
        }
        if (o instanceof Date) {
            return o;
        }
        if (o instanceof Double || o instanceof Float) {
            return o;
        }
        if (o instanceof Long || o instanceof Integer) {
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof Label) {
            return ((Label)o).getLabel();
        }
        if (o instanceof ApplicationUser) {
            return ((ApplicationUser)o).getUsername();
        }
        if (o instanceof User) {
            return ((User)o).getName();
        }
        if (o instanceof Group) {
            return ((Group)o).getName();
        }
        if (o instanceof Project) {
            return ((Project)o).getKey();
        }
        if (o instanceof Issue) {
            return ((Issue)o).getKey();
        }
        if (o instanceof Version) {
            return ((Version)o).getName();
        }
        if (o instanceof Priority) {
            return ((Priority)o).getName();
        }
        if (o instanceof Resolution) {
            return ((Resolution)o).getName();
        }
        if (o instanceof Status) {
            return ((Status)o).getName();
        }
        if (o instanceof ProjectComponent) {
            return ((ProjectComponent)o).getName();
        }
        if (o instanceof IssueType) {
            return ((IssueType)o).getName();
        }
        if (o instanceof Comment) {
            return ((Comment)o).getBody();
        }
        if (o instanceof Comment) {
            return ((Comment)o).getBody();
        }
        if (o instanceof Attachment) {
            return o;
        }
        if (o instanceof IssueSecurityLevel) {
            return ((IssueSecurityLevel)o).getName();
        }
        if (o instanceof IssueLink) {
            throw new IllegalStateException("IssueLink type is not supported.");
        }
        if (field instanceof CustomField) {
            return ((CustomField)field).getCustomFieldType().getStringFromSingularObject(o);
        }
        throw new IllegalStateException(o.getClass().getName() + " type is not supported.");
    }

    private IssueSecurityLevel convertToSecurityLevel(Object value, IssueContext issueContext) {
        if (value == null) {
            return null;
        }
        Collection levels = this.issueSecurityLevelManager.getIssueSecurityLevelsByName(FieldValueHolder.toCFString(value).trim());
        Scheme scheme = this.issueSecuritySchemeManager.getSchemeFor(issueContext.getProjectObject());
        if (scheme == null) {
            throw new IllegalArgumentException("No Issue Security Scheme is applicable to project \"" + issueContext.getProjectObject().getKey() + "\".");
        }
        IssueSecurityLevel newLevel = null;
        for (IssueSecurityLevel securityLevel : levels) {
            if (!securityLevel.getSchemeId().equals(scheme.getId())) continue;
            newLevel = securityLevel;
            break;
        }
        if (newLevel != null) {
            return newLevel;
        }
        try {
            newLevel = this.issueSecurityLevelManager.getSecurityLevel(this.toDouble(value).longValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (newLevel != null) {
            return newLevel;
        }
        throw new IllegalArgumentException("Security level \"" + FieldValueHolder.toCFString(value).trim() + "\" is not applicable to the current issue.");
    }

    private IssueConstant convertToIssueConstant(String constantType, Object value) {
        if (value == null) {
            return null;
        }
        IssueConstant issueConstant = this.constantsManager.getIssueConstantByName(constantType, FieldValueHolder.toCFString(value));
        if (issueConstant != null) {
            return issueConstant;
        }
        issueConstant = this.constantsManager.getIssueConstantByName(constantType, FieldValueHolder.toCFString(value).trim());
        if (issueConstant != null) {
            return issueConstant;
        }
        issueConstant = this.constantsManager.getConstantObject(constantType, FieldValueHolder.toCFString(value).trim());
        if (issueConstant != null) {
            return issueConstant;
        }
        throw new IllegalArgumentException("No " + constantType + " found with value '" + FieldValueHolder.toCFString(value) + "'");
    }

    private ProjectComponent convertToComponent(IssueContext issueContext, Object value) {
        if (value == null) {
            return null;
        }
        ProjectComponent component = this.projectComponentManager.findByComponentName(issueContext.getProjectId(), FieldValueHolder.toCFString(value));
        if (component != null) {
            return component;
        }
        component = this.projectComponentManager.findByComponentName(issueContext.getProjectId(), FieldValueHolder.toCFString(value).trim());
        if (component != null) {
            return component;
        }
        try {
            component = this.projectComponentManager.getProjectComponent(Long.valueOf(this.toDouble(value).longValue()));
            if (component != null) {
                return component;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("No Component found with value '" + FieldValueHolder.toCFString(value) + "' in project " + issueContext.getProjectObject().getKey());
    }

    private Version convertToVersion(IssueContext issueContext, Object value) {
        if (value == null) {
            return null;
        }
        Version version = this.versionManager.getVersion(issueContext.getProjectId(), FieldValueHolder.toCFString(value));
        if (version != null) {
            return version;
        }
        version = this.versionManager.getVersion(issueContext.getProjectId(), FieldValueHolder.toCFString(value).trim());
        if (version != null) {
            return version;
        }
        try {
            version = this.versionManager.getVersion(Long.valueOf(this.toDouble(value).longValue()));
            if (version != null) {
                return version;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IllegalArgumentException("No Version found with value '" + FieldValueHolder.toCFString(value).trim() + "' in project " + issueContext.getProjectObject().getKey());
    }

    private ApplicationUser convertToAppUser(Object value) {
        if (value == null) {
            return null;
        }
        String username = FieldValueHolder.toCFString(value).trim();
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user == null) {
            throw new IllegalArgumentException("No user found with username '" + username + "'");
        }
        return user;
    }

    private Option convertToOption(IssueContext issueContext, CustomField customField, Object value) {
        Option option;
        if (value == null) {
            return null;
        }
        FieldConfig relevantConfig = customField.getRelevantConfig(issueContext);
        if (value instanceof Number && (option = this.optionsManager.findByOptionId(Long.valueOf(((Number)value).longValue()))) != null && relevantConfig != null && relevantConfig.equals(option.getRelatedCustomField())) {
            return option;
        }
        List<Option> options = this.optionsManager.findByOptionValue(FieldValueHolder.toCFString(value));
        if (options.size() == 0) {
            options = this.optionsManager.findByOptionValue(FieldValueHolder.toCFString(value).trim());
        }
        if (options.size() == 0) {
            try {
                Long optionId = Long.parseLong(FieldValueHolder.toCFString(value).trim());
                Option option2 = this.optionsManager.findByOptionId(optionId);
                options = Collections.singletonList(option2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (Option option2 : options) {
            FieldConfig fieldConfig = option2.getRelatedCustomField();
            if (relevantConfig == null || !relevantConfig.equals(fieldConfig)) continue;
            return option2;
        }
        throw new IllegalArgumentException("No option found with ID or value '" + value + "' for custom field '" + customField.getName() + "' on issue type '" + issueContext.getIssueTypeObject().getName() + "' in project " + issueContext.getProjectObject().getKey());
    }

    private Option convertToChildOption(IssueContext issueContext, CustomField customField, Option parent, Object value) {
        if (value == null) {
            return null;
        }
        String stringValue = FieldValueHolder.toCFString(value);
        Long optionId = null;
        try {
            optionId = Long.parseLong(stringValue.trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        for (Option option : parent.getChildOptions()) {
            if (value instanceof Number && option.getOptionId().equals(((Number)value).longValue())) {
                return option;
            }
            if (option.getValue().equals(stringValue) || option.getValue().equals(stringValue.trim())) {
                return option;
            }
            if (optionId == null || !option.getOptionId().equals(optionId)) continue;
            return option;
        }
        throw new IllegalArgumentException("No child option found with ID or value '" + value + "' for Option '" + parent.getValue() + "' of custom field '" + customField.getName() + "' on issue type '" + issueContext.getIssueTypeObject().getName() + "' in project " + issueContext.getProjectObject().getKey());
    }

    private void setMultiFieldValue(IssueInputParameters issueInputParameters, FieldValueHolder fieldValueHolder, Class clazz, IssueContext issueContext, String fieldId) {
        List<Object> values = fieldValueHolder.getMultiValues(",");
        String[] strings = new String[values.size()];
        int pos = 0;
        for (Object value : values) {
            if (ApplicationUser.class.isAssignableFrom(clazz)) {
                value = this.convertToAppUser(value).getUsername();
            } else if (Version.class.isAssignableFrom(clazz)) {
                value = this.convertToVersion(issueContext, value).getId();
            } else if (ProjectComponent.class.isAssignableFrom(clazz)) {
                value = this.convertToComponent(issueContext, value).getId();
            }
            strings[pos++] = FieldValueHolder.toCFString(value);
        }
        issueInputParameters.addCustomFieldValue(fieldId, strings);
    }

    private Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.parseDouble(FieldValueHolder.toCFString(value).trim());
    }

    private Long toDuration(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            try {
                return Long.parseLong((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return this.jiraDurationUtils.parseDuration((String)value, this.applicationProperties.getDefaultLocale());
                }
                catch (InvalidDurationException invalidDurationException) {
                    // empty catch block
                }
            }
        }
        return Long.parseLong(FieldValueHolder.toCFString(value).trim());
    }

    private Timestamp toDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof String) {
            try {
                return new Timestamp(Date.parse((String)value));
            }
            catch (IllegalArgumentException e) {
                return this.dateConverter.getTimestamp((String)value);
            }
        }
        throw new IllegalArgumentException("Invalid date value: " + value);
    }

    private Timestamp toDateTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof String) {
            try {
                return new Timestamp(Date.parse((String)value));
            }
            catch (IllegalArgumentException e) {
                return new Timestamp(this.dateTimeConverter.parse((String)value).getTime());
            }
        }
        throw new IllegalArgumentException("Invalid date/time value: " + value);
    }

    private <T> Set<T> getMultiFieldValue(FieldValueHolder fieldValueHolder, Class clazz, IssueContext issueContext) {
        List<Object> values = fieldValueHolder.getMultiValues(",");
        HashSet<Object> retVals = new HashSet<Object>(values.size());
        for (Object value : values) {
            if (ApplicationUser.class.isAssignableFrom(clazz)) {
                value = this.convertToAppUser(value);
            } else if (Version.class.isAssignableFrom(clazz)) {
                value = this.convertToVersion(issueContext, value);
            } else if (ProjectComponent.class.isAssignableFrom(clazz)) {
                value = this.convertToComponent(issueContext, value);
            }
            retVals.add(value);
        }
        return retVals;
    }

    private void startWatching(MutableIssue issue, ApplicationUser u) {
        try {
            Method startWatching = WatcherManager.class.getMethod("startWatching", ApplicationUser.class, Issue.class);
            Issue newIssue = (Issue)startWatching.invoke((Object)this.watcherManager, u, issue);
            if (newIssue != null) {
                issue.setWatches(newIssue.getWatches());
            }
        }
        catch (ReflectiveOperationException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void stopWatching(MutableIssue issue, ApplicationUser u) {
        try {
            Method stopWatching = WatcherManager.class.getMethod("stopWatching", ApplicationUser.class, Issue.class);
            Issue newIssue = (Issue)stopWatching.invoke((Object)this.watcherManager, u, issue);
            if (newIssue != null) {
                issue.setWatches(newIssue.getWatches());
            }
        }
        catch (ReflectiveOperationException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private void setIssueComponents(MutableIssue issue, Collection<ProjectComponent> components) {
        try {
            Method setComponentObjects = issue.getClass().getMethod("setComponentObjects", Collection.class);
            setComponentObjects.invoke((Object)issue, components);
        }
        catch (NoSuchMethodException e) {
            try {
                Method setComponents = issue.getClass().getMethod("setComponent", Collection.class);
                setComponents.invoke((Object)issue, components);
            }
            catch (NoSuchMethodException e1) {
                Throwables.propagate((Throwable)e1);
            }
            catch (InvocationTargetException e1) {
                Throwables.propagate((Throwable)e1);
            }
            catch (IllegalAccessException e1) {
                Throwables.propagate((Throwable)e1);
            }
        }
        catch (InvocationTargetException e) {
            Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Throwables.propagate((Throwable)e);
        }
    }
}

