/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.HashMap;
import java.util.Map;
import webwork.action.ActionContext;
import webwork.action.factory.ParameterMap;

public class WorkflowPreviousStatusValidator
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginValidatorFactory {
    private final WorkflowManager workflowManager;

    protected WorkflowPreviousStatusValidator(ThirdPartyPluginLicenseStorageManager licenseManager, WorkflowManager wm) {
        super(licenseManager);
        this.workflowManager = wm;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        ActionContext ctx = ActionContext.getContext();
        ParameterMap pm = (ParameterMap)ctx.get((Object)"webwork.action.ActionContext.parameters");
        String workflowName = ((String[])pm.get((Object)"workflowName"))[0];
        JiraWorkflow workflow = this.workflowManager.getWorkflow(workflowName);
        velocityParams.put("statusList", workflow.getLinkedStatusObjects());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        String statusString = (String)validatorDescriptor.getArgs().get("jira.previousstatus");
        velocityParams.put("selectedStatus", statusString);
        String mostRecentStatusOnly = (String)validatorDescriptor.getArgs().get("jira.mostRecentStatusOnly");
        velocityParams.put("mostRecentOnly", mostRecentStatusOnly);
    }

    public Map getDescriptorParams(Map formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String selectedStatus = this.extractSingleParam(formParams, "status");
            params.put("jira.previousstatus", selectedStatus);
        }
        catch (IllegalArgumentException selectedStatus) {
            // empty catch block
        }
        try {
            String mostRecentStatusOnlyString = this.extractSingleParam(formParams, "mostRecentOnly");
            params.put("jira.mostRecentStatusOnly", mostRecentStatusOnlyString);
        }
        catch (IllegalArgumentException e) {
            params.put("jira.mostRecentStatusOnly", "no");
        }
        return params;
    }
}

