/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.comparator.IssueStatusComparator;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.innovalog.jmwe.plugins.functions.LinkUtil;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public class WorkflowLinkedIssuesStatusValidator
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginValidatorFactory {
    public static final String ERROR_MESSAGE = "errorMessage";
    private static final String STATUS_ID_PARAM_KEY = "issue_statuses";
    private static final String LINK_TYPE_NAME = "linkTypeName";
    private static final String LINK_TYPES_LIST = "linkTypeList";
    static final String SELECTED_LINK_TYPE = "selectedLinkType";
    static final String INWARD = "inward";
    private final IssueLinkTypeManager issueLinkTypeManager;
    private final ConstantsManager constantsManager;

    public WorkflowLinkedIssuesStatusValidator(ThirdPartyPluginLicenseStorageManager licenseManager, IssueLinkTypeManager issueLinkTypeManager, ConstantsManager constantsManager) {
        super(licenseManager);
        this.issueLinkTypeManager = issueLinkTypeManager;
        this.constantsManager = constantsManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        velocityParams.put("selectedStatuses", this.getSelectedStatusIds(descriptor));
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        Collection statuses = this.constantsManager.getStatusObjects();
        velocityParams.put("statuses", Collections.unmodifiableCollection(statuses));
        Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypes(false);
        velocityParams.put(LINK_TYPES_LIST, Collections.unmodifiableCollection(issueLinkTypes));
        velocityParams.put("linkUtil", new LinkUtil());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        Collection<String> selectedStatusIds = this.getSelectedStatusIds(descriptor);
        LinkedList<Status> selectedStatuses = new LinkedList<Status>();
        for (String statusId : selectedStatusIds) {
            selectedStatuses.add(this.constantsManager.getStatusObject(statusId));
        }
        Collections.sort(selectedStatuses, new IssueStatusComparator());
        velocityParams.put("selectedStatuses", Collections.unmodifiableCollection(selectedStatuses));
        if (!(descriptor instanceof ValidatorDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ValidatorDescriptor.");
        }
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        String selectedLinkType = (String)validatorDescriptor.getArgs().get(SELECTED_LINK_TYPE);
        velocityParams.put(SELECTED_LINK_TYPE, selectedLinkType);
        if (!StringUtils.isBlank((String)selectedLinkType)) {
            boolean isInwardLink = selectedLinkType.split(":")[0].equalsIgnoreCase(INWARD);
            try {
                Long linkTypeId = new Long(Long.parseLong(selectedLinkType.split(":")[1]));
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(linkTypeId, false);
                if (issueLinkType == null) {
                    velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
                } else {
                    velocityParams.put(LINK_TYPE_NAME, isInwardLink ? issueLinkType.getInward() : issueLinkType.getOutward());
                }
            }
            catch (NumberFormatException e) {
                velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
            }
        }
        velocityParams.put(ERROR_MESSAGE, validatorDescriptor.getArgs().get(ERROR_MESSAGE));
        velocityParams.put("linkUtil", new LinkUtil());
    }

    public Map getDescriptorParams(Map formParams) {
        StringBuilder statIds;
        HashMap<String, String> params = new HashMap<String, String>();
        String[] statusIds = (String[])formParams.get(STATUS_ID_PARAM_KEY);
        if (statusIds != null) {
            statIds = new StringBuilder();
            for (String statusId : statusIds) {
                statIds.append(statusId).append(",");
            }
        } else {
            throw new IllegalArgumentException("Please select at least one status.");
        }
        params.put("statuses", statIds.substring(0, statIds.length() - 1));
        params.put(SELECTED_LINK_TYPE, this.extractSingleParam(formParams, SELECTED_LINK_TYPE));
        String strErrorMessage = this.extractSingleParam(formParams, ERROR_MESSAGE);
        params.put(ERROR_MESSAGE, strErrorMessage);
        return params;
    }

    private Collection<String> getSelectedStatusIds(AbstractDescriptor descriptor) {
        LinkedList<String> selectedStatusIds = new LinkedList<String>();
        if (!(descriptor instanceof ValidatorDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ValidatorDescriptor.");
        }
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        String statuses = (String)validatorDescriptor.getArgs().get("statuses");
        StringTokenizer st = new StringTokenizer(statuses, ",");
        while (st.hasMoreTokens()) {
            selectedStatusIds.add(st.nextToken());
        }
        return selectedStatusIds;
    }
}

