/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class WorkflowFieldRequiredValidator
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginValidatorFactory {
    public static final String FIELDKEY = "fieldKey";
    public static final String SELECTED_FIELD = "selectedField";
    public static final String FIELD_LIST = "fieldList";
    public static final String ERROR_MESSAGE = "errorMessage";
    private final FieldCollectionsUtils fieldCollectionsUtils;
    private final FieldManager fieldManager;

    public WorkflowFieldRequiredValidator(FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, FieldManager fieldManager) {
        super(licenseManager);
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.fieldManager = fieldManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        Map args = validatorDescriptor.getArgs();
        String strFields = (String)args.get("hidFieldsList");
        if (!StringUtils.isEmpty(strFields)) {
            if ((strFields = strFields.replaceAll("@@", ",")).endsWith(",")) {
                strFields = strFields.substring(0, strFields.length() - 1);
            }
        } else {
            strFields = (String)args.get(FIELDKEY);
        }
        velocityParams.put("field", strFields);
        if (strFields != null) {
            StringBuilder sb = new StringBuilder();
            boolean bFirst = true;
            for (String fieldKey : strFields.split(",")) {
                if (bFirst) {
                    bFirst = false;
                } else {
                    sb.append(", ");
                }
                Field f = this.fieldManager.getField(fieldKey);
                if (f == null) {
                    sb.append("<i>Invalid field (" + fieldKey + ")</i>");
                    continue;
                }
                sb.append(f.getName());
            }
            velocityParams.put("fields", sb.toString());
        } else {
            velocityParams.put("fields", "<i>No field specified</i>");
        }
        velocityParams.put(ERROR_MESSAGE, args.get(ERROR_MESSAGE));
    }

    public Map<String, String> getDescriptorParams(Map formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String strErrorMessage = this.extractSingleParam(formParams, ERROR_MESSAGE);
            params.put(ERROR_MESSAGE, strErrorMessage);
        }
        catch (IllegalArgumentException strErrorMessage) {
            // empty catch block
        }
        try {
            String sourceField = this.extractSingleParam(formParams, "field");
            params.put(FIELDKEY, sourceField);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        params.put("hidFieldsList", null);
        return params;
    }
}

