/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.plugin.workflow.WorkflowPluginValidatorFactory;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.AbstractLicensedWorkflowPluginFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ValidatorDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowCommentRequiredValidator
extends AbstractLicensedWorkflowPluginFactory
implements WorkflowPluginValidatorFactory {
    public static final String ERROR_MESSAGE = "errorMessage";
    private final WorkflowUtils workflowUtils;
    private final GroupManager groupManager;

    public WorkflowCommentRequiredValidator(WorkflowUtils workflowUtils, GroupManager groupManager, ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
        this.workflowUtils = workflowUtils;
        this.groupManager = groupManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        Map args = validatorDescriptor.getArgs();
        String strGroupsSelected = (String)args.get("hidGroupsList");
        if (strGroupsSelected == null || strGroupsSelected.length() == 0) {
            strGroupsSelected = "";
        } else if ((strGroupsSelected = strGroupsSelected.replaceAll("@@", ",")).charAt(strGroupsSelected.length() - 1) == ',') {
            strGroupsSelected = strGroupsSelected.substring(0, strGroupsSelected.length() - 1);
        }
        velocityParams.put("groups", strGroupsSelected);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        ValidatorDescriptor validatorDescriptor = (ValidatorDescriptor)descriptor;
        Map args = validatorDescriptor.getArgs();
        velocityParams.put(ERROR_MESSAGE, args.get(ERROR_MESSAGE));
        String strGroupsSelected = (String)args.get("hidGroupsList");
        List groupsSelected = strGroupsSelected == null ? Collections.emptyList() : this.workflowUtils.getGroups(strGroupsSelected, "@@");
        velocityParams.put("val-groupsListSelected", Collections.unmodifiableCollection(groupsSelected));
    }

    public Map getDescriptorParams(Map formParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        String strErrorMessage = this.extractSingleParam(formParams, ERROR_MESSAGE);
        params.put(ERROR_MESSAGE, strErrorMessage);
        String strGroupsSelected = this.extractSingleParam(formParams, "groups");
        params.put("hidGroupsList", strGroupsSelected.replaceAll(",", "@@"));
        return params;
    }
}

