/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.validators;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.annotation.Argument;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.validators.GenericValidator;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.InvalidInputException;
import com.opensymphony.workflow.WorkflowException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class PreviousStatusValidator
extends GenericValidator {
    private final I18nResolver i18nResolver;
    @Argument(value="jira.previousstatus")
    private String statusToLookFor;
    @Argument(value="jira.mostRecentStatusOnly")
    private String mostRecentOnlyString;

    public PreviousStatusValidator(WorkflowUtils workflowUtils, FieldCollectionsUtils fieldCollectionsUtils, ThirdPartyPluginLicenseStorageManager licenseManager, I18nResolver i18nResolver) {
        super(workflowUtils, fieldCollectionsUtils, licenseManager);
        this.i18nResolver = i18nResolver;
    }

    @Override
    protected void doValidate(Map transientVars, Map args, PropertySet ps) throws InvalidInputException, WorkflowException {
        Issue genericIssue = this.getIssue();
        boolean mostRecentStatusOnly = this.mostRecentOnlyString.equals("yes");
        ChangeHistoryManager changeHistoryManager = (ChangeHistoryManager)ComponentManager.getComponentInstanceOfType(ChangeHistoryManager.class);
        List changeHistory = changeHistoryManager.getChangeHistories(genericIssue);
        block0: for (int i = changeHistory.size() - 1; i >= 0; --i) {
            ChangeHistory changeHistoryItem = (ChangeHistory)changeHistory.get(i);
            List changeItemBeans = changeHistoryItem.getChangeItems();
            for (GenericValue change : changeItemBeans) {
                String changedField = change.getString("field");
                if (!changedField.equalsIgnoreCase("status")) continue;
                String oldStatus = change.getString("oldstring");
                if (oldStatus.compareToIgnoreCase(this.statusToLookFor) == 0) {
                    return;
                }
                if (!mostRecentStatusOnly) continue block0;
                i = 0;
                continue block0;
            }
        }
        String msg = mostRecentStatusOnly ? this.i18nResolver.getText("previous.status.validator.msg.most.recent", new Serializable[]{this.statusToLookFor}) : this.i18nResolver.getText("previous.status.validator.msg", new Serializable[]{this.statusToLookFor});
        throw new InvalidInputException(msg);
    }
}

