/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.innovalog.jmwe.plugins.functions.LinkUtil;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowTransitionLinkedIssuesFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private Logger log = LoggerFactory.getLogger(WorkflowTransitionLinkedIssuesFunction.class);
    private static final String LINK_TYPE_NAME = "linkTypeName";
    private static final String LINK_TYPES_LIST = "linkTypeList";
    static final String SELECTED_LINK_TYPE = "selectedLinkType";
    static final String TRANSITION = "transition";
    static final String INWARD = "inward";
    private final IssueLinkTypeManager issueLinkTypeManager;

    public WorkflowTransitionLinkedIssuesFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueLinkTypeManager issueLinkTypeManager) {
        super(licenseManager);
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypes(false);
        velocityParams.put(LINK_TYPES_LIST, Collections.unmodifiableCollection(issueLinkTypes));
        velocityParams.put("linkUtil", new LinkUtil());
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = null;
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        functionDescriptor = (FunctionDescriptor)descriptor;
        String selectedLinkType = (String)functionDescriptor.getArgs().get(SELECTED_LINK_TYPE);
        velocityParams.put(SELECTED_LINK_TYPE, selectedLinkType);
        velocityParams.put(TRANSITION, functionDescriptor.getArgs().get(TRANSITION));
        velocityParams.put("runAsUser", functionDescriptor.getArgs().get("runAsUser"));
        if (!StringUtils.isBlank((String)selectedLinkType)) {
            boolean isInwardLink = selectedLinkType.split(":")[0].equalsIgnoreCase(INWARD);
            try {
                Long linkTypeId = new Long(Long.parseLong(selectedLinkType.split(":")[1]));
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(linkTypeId, false);
                if (issueLinkType == null) {
                    velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
                } else {
                    velocityParams.put(LINK_TYPE_NAME, isInwardLink ? issueLinkType.getInward() : issueLinkType.getOutward());
                }
            }
            catch (NumberFormatException e) {
                velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
            }
        }
        velocityParams.put("linkUtil", new LinkUtil());
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put(SELECTED_LINK_TYPE, this.extractSingleParam(conditionParams, SELECTED_LINK_TYPE));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            String transition = this.extractSingleParam(conditionParams, TRANSITION);
            params.put(TRANSITION, transition);
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put("runAsUser", this.extractSingleParam(conditionParams, "runAsUser"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        params.putAll(super.getDescriptorParams(conditionParams));
        return params;
    }
}

