/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.googlecode.jsu.util.FieldCollectionsUtils;
import com.googlecode.jsu.util.WorkflowUtils;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkflowSetFieldFromUserPropFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    public static final String VELOPARAM = "userPropKey";
    public static final String FUNCPARAM = "user.property.key";
    public static final String FIELD = "field";
    public static final String SELECTED_FIELD = "selectedField";
    public static final String FIELD_LIST = "fieldList";
    public static final String COPY_ONLY_IF_NOT_SET = "copyOnlyIfNotSet";
    private final WorkflowUtils workflowUtils;
    private final FieldCollectionsUtils fieldCollectionsUtils;

    public WorkflowSetFieldFromUserPropFunction(FieldCollectionsUtils fieldCollectionsUtils, WorkflowUtils workflowUtils, ThirdPartyPluginLicenseStorageManager licenseManager) {
        super(licenseManager);
        this.fieldCollectionsUtils = fieldCollectionsUtils;
        this.workflowUtils = workflowUtils;
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        velocityParams.put(VELOPARAM, "");
        List<Field> fields = this.fieldCollectionsUtils.getCopyToFields();
        velocityParams.put(FIELD_LIST, Collections.unmodifiableList(fields));
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)descriptor;
        String commentString = (String)functionDescriptor.getArgs().get(FUNCPARAM);
        velocityParams.put(VELOPARAM, commentString);
        velocityParams.put(SELECTED_FIELD, this.workflowUtils.getFieldFromDescriptor(descriptor, FIELD));
        velocityParams.put(COPY_ONLY_IF_NOT_SET, functionDescriptor.getArgs().get(COPY_ONLY_IF_NOT_SET));
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map velocityParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            String sourceField = this.extractSingleParam(velocityParams, FIELD);
            params.put(FIELD, sourceField);
            String value1 = this.extractSingleParam(velocityParams, VELOPARAM);
            params.put(FUNCPARAM, value1);
        }
        catch (IllegalArgumentException sourceField) {
            // empty catch block
        }
        try {
            params.put(COPY_ONLY_IF_NOT_SET, this.extractSingleParam(velocityParams, COPY_ONLY_IF_NOT_SET));
        }
        catch (IllegalArgumentException e) {
            params.put(COPY_ONLY_IF_NOT_SET, "no");
        }
        params.putAll(super.getDescriptorParams(velocityParams));
        return params;
    }
}

