/*
 * Decompiled with CFR 0.152.
 */
package com.innovalog.jmwe.plugins.functions;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.issue.link.IssueLinkType;
import com.atlassian.jira.issue.link.IssueLinkTypeManager;
import com.atlassian.jira.plugin.workflow.WorkflowPluginFunctionFactory;
import com.atlassian.upm.license.storage.lib.ThirdPartyPluginLicenseStorageManager;
import com.innovalog.jmwe.plugins.functions.AbstractConditionalWorkflowFunction;
import com.innovalog.jmwe.plugins.functions.LinkUtil;
import com.innovalog.jmwe.plugins.functions.Utils;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowLinkIssuesFunction
extends AbstractConditionalWorkflowFunction
implements WorkflowPluginFunctionFactory {
    private Logger log = LoggerFactory.getLogger(WorkflowLinkIssuesFunction.class);
    private static final String LINK_TYPE_NAME = "linkTypeName";
    private static final String LINK_TYPES_LIST = "linkTypeList";
    static final String SELECTED_LINK_TYPE = "selectedLinkType";
    static final String INWARD = "inward";
    static final String RUN_AS_USER = "runAsUser";
    static final String MAX_ISSUES = "maxIssues";
    static final String JQL = "jql";
    private final IssueLinkTypeManager issueLinkTypeManager;

    public WorkflowLinkIssuesFunction(ThirdPartyPluginLicenseStorageManager licenseManager, IssueLinkTypeManager issueLinkTypeManager) {
        super(licenseManager);
        this.issueLinkTypeManager = issueLinkTypeManager;
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        this.getVelocityParamsForView(velocityParams, descriptor);
        super.getVelocityParamsForEdit(velocityParams, descriptor);
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        Collection issueLinkTypes = this.issueLinkTypeManager.getIssueLinkTypes(true);
        velocityParams.put(LINK_TYPES_LIST, issueLinkTypes);
        velocityParams.put("linkUtil", new LinkUtil());
        velocityParams.put(MAX_ISSUES, 10);
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        FunctionDescriptor functionDescriptor = null;
        if (!(descriptor instanceof FunctionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a FunctionDescriptor.");
        }
        functionDescriptor = (FunctionDescriptor)descriptor;
        velocityParams.put(JQL, Utils.decodeTemplate((String)functionDescriptor.getArgs().get(JQL)));
        velocityParams.put(RUN_AS_USER, functionDescriptor.getArgs().get(RUN_AS_USER));
        velocityParams.put(MAX_ISSUES, functionDescriptor.getArgs().get(MAX_ISSUES));
        String selectedLinkType = (String)functionDescriptor.getArgs().get(SELECTED_LINK_TYPE);
        velocityParams.put(SELECTED_LINK_TYPE, selectedLinkType);
        if (!StringUtils.isBlank((String)selectedLinkType)) {
            boolean isInwardLink = selectedLinkType.split(":")[0].equalsIgnoreCase(INWARD);
            try {
                Long linkTypeId = new Long(Long.parseLong(selectedLinkType.split(":")[1]));
                IssueLinkType issueLinkType = this.issueLinkTypeManager.getIssueLinkType(linkTypeId, false);
                if (issueLinkType == null || issueLinkType.isSubTaskLinkType()) {
                    velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
                } else {
                    velocityParams.put(LINK_TYPE_NAME, isInwardLink ? issueLinkType.getInward() : issueLinkType.getOutward());
                }
            }
            catch (NumberFormatException e) {
                velocityParams.put(LINK_TYPE_NAME, "<i>invalid link type</i>");
            }
        }
        velocityParams.put("linkUtil", new LinkUtil());
        super.getVelocityParamsForView(velocityParams, descriptor);
    }

    public Map<String, String> getDescriptorParams(Map conditionParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            params.put(SELECTED_LINK_TYPE, this.extractSingleParam(conditionParams, SELECTED_LINK_TYPE));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put(JQL, Utils.encodeTemplate(this.extractSingleParam(conditionParams, JQL)));
        }
        catch (IllegalArgumentException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        try {
            params.put(RUN_AS_USER, this.extractSingleParam(conditionParams, RUN_AS_USER));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            params.put(MAX_ISSUES, this.extractSingleParam(conditionParams, MAX_ISSUES));
        }
        catch (IllegalArgumentException e) {
            params.put(MAX_ISSUES, "10");
        }
        params.putAll(super.getDescriptorParams(conditionParams));
        return params;
    }
}

